/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.auth.facebook;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.widget.Toast;
import com.socialize.auth.AuthProviderResponse;
import com.socialize.auth.facebook.FacebookDialogListener;
import com.socialize.auth.facebook.FacebookSessionStore;
import com.socialize.error.SocializeException;
import com.socialize.facebook.Facebook;
import com.socialize.listener.AuthProviderListener;
import com.socialize.log.SocializeLogger;
import com.socialize.networks.facebook.FacebookFacade;
import com.socialize.util.DialogFactory;

public class FacebookService {
    private FacebookFacade facebookFacade;
    private AuthProviderListener listener;
    private SocializeLogger logger;
    private String appId;
    private FacebookSessionStore facebookSessionStore;
    private Facebook facebook;
    private DialogFactory dialogFactory;

    public FacebookService() {
    }

    @Deprecated
    public FacebookService(Facebook facebook, FacebookSessionStore facebookSessionStore, AuthProviderListener listener, DialogFactory dialogFactory, SocializeLogger logger) {
        this.facebook = facebook;
        this.facebookSessionStore = facebookSessionStore;
        this.listener = listener;
        this.dialogFactory = dialogFactory;
        this.logger = logger;
    }

    public FacebookService(String appId, FacebookFacade facebookFacade, AuthProviderListener listener, SocializeLogger logger) {
        this.appId = appId;
        this.facebookFacade = facebookFacade;
        this.listener = listener;
        this.logger = logger;
    }

    @Deprecated
    public void authenticate(Activity context) {
        this.authenticate(context, FacebookFacade.DEFAULT_PERMISSIONS, true, false);
    }

    @Deprecated
    public void authenticate(Activity context, boolean sso) {
        this.authenticate(context, FacebookFacade.DEFAULT_PERMISSIONS, sso, false);
    }

    @Deprecated
    public void authenticate(Activity context, boolean sso, String ... permissions) {
        if (permissions != null && permissions.length > 0) {
            this.authenticate(context, permissions, sso, false);
        } else {
            this.authenticate(context, FacebookFacade.DEFAULT_PERMISSIONS, sso, false);
        }
    }

    public void authenticateForRead(Activity context, boolean sso, String[] permissions) {
        this.authenticate(context, permissions, sso, true);
    }

    public void authenticateForWrite(Activity context, boolean sso, String[] permissions) {
        this.authenticate(context, permissions, sso, false);
    }

    protected void authenticate(final Activity context, String[] permissions, boolean sso, boolean read) {
        if (this.facebookFacade != null) {
            this.facebookFacade.authenticate(context, this.appId, permissions, sso, read, new AuthProviderListener(){

                @Override
                public void onError(SocializeException error) {
                    FacebookService.this.finish(context);
                    if (FacebookService.this.listener != null) {
                        FacebookService.this.listener.onError(error);
                    }
                }

                @Override
                public void onCancel() {
                    FacebookService.this.finish(context);
                    if (FacebookService.this.listener != null) {
                        FacebookService.this.listener.onCancel();
                    }
                }

                @Override
                public void onAuthSuccess(AuthProviderResponse response) {
                    FacebookService.this.finish(context);
                    if (FacebookService.this.listener != null) {
                        FacebookService.this.listener.onAuthSuccess(response);
                    }
                }

                @Override
                public void onAuthFail(SocializeException error) {
                    FacebookService.this.finish(context);
                    if (FacebookService.this.listener != null) {
                        FacebookService.this.listener.onAuthFail(error);
                    }
                }
            });
        } else {
            this.authenticateLegacy(context, permissions, sso);
        }
    }

    @Deprecated
    private void authenticateLegacy(final Activity context, final String[] permissions, final boolean sso) {
        this.facebookSessionStore.restore(this.facebook, (Context)context);
        FacebookDialogListener facebookDialogListener = new FacebookDialogListener((Context)context, this.facebook, this.facebookSessionStore, this.listener){

            @Override
            public void onFinish() {
                FacebookService.this.finish(context);
            }

            @Override
            public void handleError(Throwable error) {
                if (FacebookService.this.listener != null) {
                    FacebookService.this.listener.onError(new SocializeException(error));
                } else {
                    FacebookService.this.doError(context, error, permissions, sso);
                }
            }
        };
        if (sso) {
            this.facebook.authorize(context, permissions, facebookDialogListener);
        } else {
            this.facebook.authorize(context, permissions, -1, facebookDialogListener);
        }
    }

    public void finish(Activity context) {
        context.finish();
    }

    public void cancel(Activity context) {
        if (this.listener != null) {
            this.listener.onCancel();
        } else {
            Toast.makeText((Context)context, (CharSequence)"Request cancelled", (int)0).show();
        }
    }

    public void logout(Activity context) {
        try {
            if (this.facebookFacade != null) {
                this.facebookFacade.logout((Context)context);
            } else if (this.facebook != null) {
                this.facebook.logout((Context)context);
            }
        }
        catch (Exception e) {
            if (this.listener != null) {
                this.listener.onError(new SocializeException(e));
            }
            if (this.logger != null) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            e.printStackTrace();
        }
    }

    @Deprecated
    public void doError(final Activity context, final Throwable e, final String[] permissions, final boolean sso) {
        context.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (FacebookService.this.logger != null) {
                    FacebookService.this.logger.error("Facebook error", e);
                } else {
                    e.printStackTrace();
                }
                FacebookService.this.doErrorUI(context, e.getMessage(), permissions, sso);
            }
        });
    }

    @Deprecated
    public void doErrorUI(Activity context, String error, String[] permissions, boolean sso) {
        try {
            this.makeErrorDialog(context, error, permissions, sso).show();
        }
        catch (Exception e) {
            if (this.logger != null) {
                this.logger.error("Facebook error", (Throwable)e);
            }
            e.printStackTrace();
        }
    }

    @Deprecated
    public AlertDialog makeErrorDialog(final Activity context, String error, final String[] permissions, final boolean sso) {
        AlertDialog.Builder builder = this.dialogFactory.getAlertDialogBuilder((Context)context);
        builder.setTitle((CharSequence)"Oops!");
        builder.setMessage((CharSequence)("Oops!\nSomething went wrong...\n[" + error + "]"));
        builder.setCancelable(false);
        builder.setPositiveButton((CharSequence)"Try again", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int id) {
                dialog.dismiss();
                FacebookService.this.authenticate(context, permissions, sso, false);
            }
        });
        builder.setNegativeButton((CharSequence)"Cancel", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int id) {
                dialog.dismiss();
                FacebookService.this.finish(context);
            }
        });
        return builder.create();
    }
}

