/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.auth.facebook;

import com.socialize.android.ioc.IBeanFactory;
import com.socialize.auth.BaseAuthProviderInfoFactory;
import com.socialize.auth.facebook.FacebookAuthProviderInfo;
import com.socialize.networks.facebook.FacebookFacade;
import com.socialize.util.ArrayUtils;

public class FacebookAuthProviderInfoFactory
extends BaseAuthProviderInfoFactory<FacebookAuthProviderInfo> {
    private IBeanFactory<FacebookAuthProviderInfo> facebookAuthProviderInfoInstanceFactory;

    @Override
    public FacebookAuthProviderInfo initInstanceForRead(String ... permissions) {
        if (ArrayUtils.isEmpty(permissions)) {
            permissions = FacebookFacade.READ_PERMISSIONS;
        }
        FacebookAuthProviderInfo info = (FacebookAuthProviderInfo)this.facebookAuthProviderInfoInstanceFactory.getBean();
        info.setAppId(this.config.getProperty("facebook.app.id"));
        info.setReadPermissions(permissions);
        info.setPermissionType(FacebookAuthProviderInfo.PermissionType.READ);
        return info;
    }

    @Override
    public FacebookAuthProviderInfo initInstanceForWrite(String ... permissions) {
        if (ArrayUtils.isEmpty(permissions)) {
            permissions = FacebookFacade.WRITE_PERMISSIONS;
        }
        FacebookAuthProviderInfo info = (FacebookAuthProviderInfo)this.facebookAuthProviderInfoInstanceFactory.getBean();
        info.setAppId(this.config.getProperty("facebook.app.id"));
        info.setWritePermissions(permissions);
        info.setPermissionType(FacebookAuthProviderInfo.PermissionType.WRITE);
        return info;
    }

    @Override
    protected void updateForRead(FacebookAuthProviderInfo info, String ... permissions) {
        if (ArrayUtils.isEmpty(permissions)) {
            permissions = FacebookFacade.READ_PERMISSIONS;
        }
        info.setAppId(this.config.getProperty("facebook.app.id"));
        info.mergeForRead(permissions);
        info.setPermissionType(FacebookAuthProviderInfo.PermissionType.READ);
    }

    @Override
    protected void updateForWrite(FacebookAuthProviderInfo info, String ... permissions) {
        if (ArrayUtils.isEmpty(permissions)) {
            permissions = FacebookFacade.WRITE_PERMISSIONS;
        }
        info.setAppId(this.config.getProperty("facebook.app.id"));
        info.mergeForWrite(permissions);
        info.setPermissionType(FacebookAuthProviderInfo.PermissionType.WRITE);
    }

    public void setFacebookAuthProviderInfoInstanceFactory(IBeanFactory<FacebookAuthProviderInfo> facebookAuthProviderInfoInstanceFactory) {
        this.facebookAuthProviderInfoInstanceFactory = facebookAuthProviderInfoInstanceFactory;
    }
}

