/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.auth.facebook;

import com.socialize.auth.AuthProviderInfo;
import com.socialize.auth.AuthProviderType;
import com.socialize.error.SocializeException;
import com.socialize.util.ArrayUtils;
import com.socialize.util.StringUtils;
import java.util.Arrays;
import java.util.HashSet;

public class FacebookAuthProviderInfo
implements AuthProviderInfo {
    private static final long serialVersionUID = -6472972851879738516L;
    private String appId;
    private String[] readPermissions;
    private String[] writePermissions;
    private PermissionType permissionType = PermissionType.READ;

    @Override
    public AuthProviderType getType() {
        return AuthProviderType.FACEBOOK;
    }

    @Override
    public void validate() throws SocializeException {
        if (!this.isValid()) {
            throw new SocializeException("No facebook app ID found.");
        }
    }

    public PermissionType getPermissionType() {
        return this.permissionType;
    }

    public void setPermissionType(PermissionType permissionType) {
        this.permissionType = permissionType;
    }

    @Override
    public boolean isValid() {
        return !StringUtils.isEmpty(this.appId);
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    @Deprecated
    public String[] getPermissions() {
        return this.getWritePermissions();
    }

    @Deprecated
    public void setPermissions(String[] permissions) {
        this.setWritePermissions(permissions);
    }

    public String[] getReadPermissions() {
        return this.readPermissions;
    }

    public void setReadPermissions(String[] readPermissions) {
        this.readPermissions = readPermissions;
    }

    public String[] getWritePermissions() {
        return this.writePermissions;
    }

    public void setWritePermissions(String[] writePermissions) {
        this.writePermissions = writePermissions;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.appId == null ? 0 : this.appId.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FacebookAuthProviderInfo other = (FacebookAuthProviderInfo)obj;
        return !(this.appId == null ? other.appId != null : !this.appId.equals(other.appId));
    }

    public void mergeForRead(String[] newPermissions) {
        this.readPermissions = this.merge(newPermissions, this.readPermissions);
    }

    public void mergeForWrite(String[] newPermissions) {
        this.writePermissions = this.merge(newPermissions, this.writePermissions);
    }

    String[] merge(String[] newPermissions, String[] oldPermissions) {
        HashSet<String> allPermissions = new HashSet<String>();
        if (oldPermissions != null) {
            allPermissions.addAll(Arrays.asList(oldPermissions));
        }
        allPermissions.addAll(Arrays.asList(newPermissions));
        oldPermissions = allPermissions.toArray(new String[allPermissions.size()]);
        Arrays.sort(oldPermissions);
        return oldPermissions;
    }

    @Override
    public boolean merge(AuthProviderInfo info) {
        if (info instanceof FacebookAuthProviderInfo) {
            FacebookAuthProviderInfo that = (FacebookAuthProviderInfo)info;
            if (that.readPermissions != null) {
                this.readPermissions = this.merge(that.readPermissions, this.readPermissions);
            }
            if (that.writePermissions != null) {
                this.writePermissions = this.merge(that.writePermissions, this.writePermissions);
            }
            if (this.permissionType.equals((Object)PermissionType.READ)) {
                this.permissionType = that.permissionType;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean matches(AuthProviderInfo info) {
        if (this.equals(info) && info instanceof FacebookAuthProviderInfo) {
            FacebookAuthProviderInfo that = (FacebookAuthProviderInfo)info;
            if (that.getPermissionType().equals((Object)PermissionType.WRITE)) {
                if (this.getPermissionType().equals((Object)that.getPermissionType())) {
                    return this.matches(that.writePermissions, this.writePermissions);
                }
            } else {
                return this.matches(that.readPermissions, this.readPermissions);
            }
        }
        return false;
    }

    boolean matches(String[] expected, String[] actual) {
        if (Arrays.equals(actual, expected)) {
            return true;
        }
        if (ArrayUtils.isEmpty(expected) && ArrayUtils.isEmpty(actual)) {
            return true;
        }
        if (actual != null && expected != null) {
            Arrays.sort(actual);
            for (int i = 0; i < expected.length; ++i) {
                if (Arrays.binarySearch(actual, expected[i]) >= 0) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static enum PermissionType {
        READ,
        WRITE;

    }
}

