/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.auth.facebook;

import android.app.Activity;
import android.content.Context;
import com.socialize.auth.AuthProvider;
import com.socialize.auth.AuthProviderInfo;
import com.socialize.auth.AuthProviderInfoBuilder;
import com.socialize.auth.AuthProviderType;
import com.socialize.auth.facebook.FacebookAuthProviderInfo;
import com.socialize.config.SocializeConfig;
import com.socialize.error.SocializeException;
import com.socialize.listener.AuthProviderListener;
import com.socialize.networks.facebook.FacebookFacade;

public class FacebookAuthProvider
implements AuthProvider<FacebookAuthProviderInfo> {
    private FacebookFacade facebookFacade;
    private AuthProviderInfoBuilder authProviderInfoBuilder;
    private SocializeConfig config;

    @Override
    public boolean validateForRead(FacebookAuthProviderInfo info, String ... permissions) {
        if (this.authProviderInfoBuilder != null) {
            Object expected = this.authProviderInfoBuilder.getFactory(AuthProviderType.FACEBOOK).initInstanceForRead(permissions);
            return info.matches((AuthProviderInfo)expected);
        }
        return true;
    }

    @Override
    public boolean validateForWrite(FacebookAuthProviderInfo info, String ... permissions) {
        if (this.authProviderInfoBuilder != null) {
            Object expected = this.authProviderInfoBuilder.getFactory(AuthProviderType.FACEBOOK).initInstanceForWrite(permissions);
            return info.matches((AuthProviderInfo)expected);
        }
        return true;
    }

    @Override
    @Deprecated
    public boolean validate(FacebookAuthProviderInfo info) {
        return this.validateForRead(info, FacebookFacade.DEFAULT_PERMISSIONS);
    }

    @Override
    public void authenticate(Context context, FacebookAuthProviderInfo info, AuthProviderListener listener) {
        if (context instanceof Activity) {
            boolean sso = this.config.getBooleanProperty("facebook.sso.enabled", true);
            this.facebookFacade.authenticateWithActivity((Activity)context, info, sso, listener);
        } else if (listener != null) {
            listener.onError(new SocializeException("Facebook authentication can only be performed from an activity.  The given context [" + context.getClass().getName() + "] is not an activity"));
        }
    }

    @Override
    public void clearCache(Context context, FacebookAuthProviderInfo info) {
        this.facebookFacade.logout(context);
    }

    public void setFacebookFacade(FacebookFacade facebookFacade) {
        this.facebookFacade = facebookFacade;
    }

    public void setAuthProviderInfoBuilder(AuthProviderInfoBuilder authProviderInfoBuilder) {
        this.authProviderInfoBuilder = authProviderInfoBuilder;
    }

    public void setConfig(SocializeConfig config) {
        this.config = config;
    }
}

