/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.auth.facebook;

import android.content.Intent;
import android.os.Bundle;
import com.socialize.auth.facebook.FacebookActivity;
import com.socialize.auth.facebook.FacebookAuthProviderInfo;
import com.socialize.auth.facebook.FacebookService;
import com.socialize.config.SocializeConfig;
import com.socialize.listener.AuthProviderListener;
import com.socialize.listener.ListenerHolder;
import com.socialize.log.SocializeLogger;
import com.socialize.networks.facebook.FacebookFacade;
import com.socialize.util.StringUtils;

public class FacebookActivityService {
    private FacebookFacade facebookFacade;
    private ListenerHolder listenerHolder;
    private FacebookActivity activity;
    private SocializeConfig config;
    private SocializeLogger logger;
    private FacebookService service;

    public FacebookActivityService(FacebookActivity activity) {
        this.activity = activity;
    }

    public FacebookActivityService() {
    }

    public void onCreate() {
        Intent intent = this.activity.getIntent();
        if (intent != null) {
            Bundle extras = intent.getExtras();
            if (extras != null) {
                String[] permissions = extras.getStringArray("permissions");
                this.listenerHolder = (ListenerHolder)this.activity.getBean("listenerHolder");
                this.logger = (SocializeLogger)this.activity.getBean("logger");
                this.config = (SocializeConfig)this.activity.getBean("config");
                this.facebookFacade = (FacebookFacade)this.activity.getBean("facebookFacadeFactory");
                this.service = this.getFacebookService();
                boolean sso = extras.getBoolean("sso");
                String type = extras.getString("type");
                FacebookAuthProviderInfo.PermissionType pType = FacebookAuthProviderInfo.PermissionType.READ;
                if (!StringUtils.isEmpty(type)) {
                    pType = FacebookAuthProviderInfo.PermissionType.valueOf(type);
                }
                if (permissions != null && permissions.length > 0) {
                    if (pType.equals((Object)FacebookAuthProviderInfo.PermissionType.READ)) {
                        this.service.authenticateForRead(this.activity, sso, permissions);
                    } else {
                        this.service.authenticateForWrite(this.activity, sso, permissions);
                    }
                } else {
                    this.service.authenticateForRead(this.activity, sso, FacebookFacade.READ_PERMISSIONS);
                }
            } else {
                this.activity.finish();
            }
        } else {
            this.activity.finish();
        }
    }

    public void onCancel() {
        if (this.service != null) {
            this.service.cancel(this.activity);
        }
    }

    public FacebookService getFacebookService() {
        this.service = new FacebookService(this.config.getProperty("facebook.app.id"), this.facebookFacade, (AuthProviderListener)this.listenerHolder.pop("auth"), this.logger);
        return this.service;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (this.facebookFacade != null) {
            this.facebookFacade.onActivityResult(this.activity, requestCode, resultCode, data);
        }
    }

    public void setService(FacebookService service) {
        this.service = service;
    }

    public void setActivity(FacebookActivity activity) {
        this.activity = activity;
    }

    public void setLogger(SocializeLogger logger) {
        this.logger = logger;
    }

    public void setFacebookFacade(FacebookFacade facebookFacade) {
        this.facebookFacade = facebookFacade;
    }
}

