/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.api.action.like;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.util.Log;
import android.view.View;
import android.widget.CompoundButton;
import com.socialize.LikeUtils;
import com.socialize.UserUtils;
import com.socialize.api.SocializeSession;
import com.socialize.api.action.ShareType;
import com.socialize.api.action.SocializeActionUtilsBase;
import com.socialize.api.action.like.LikeOptions;
import com.socialize.api.action.like.LikeSystem;
import com.socialize.api.action.like.LikeUtilsProxy;
import com.socialize.entity.Entity;
import com.socialize.entity.Like;
import com.socialize.entity.User;
import com.socialize.error.SocializeApiError;
import com.socialize.error.SocializeException;
import com.socialize.listener.like.IsLikedListener;
import com.socialize.listener.like.LikeAddListener;
import com.socialize.listener.like.LikeDeleteListener;
import com.socialize.listener.like.LikeGetListener;
import com.socialize.listener.like.LikeListListener;
import com.socialize.listener.like.LikeListener;
import com.socialize.log.SocializeLogger;
import com.socialize.networks.SocialNetwork;
import com.socialize.ui.actionbutton.LikeButtonListener;
import com.socialize.ui.auth.AuthDialogListener;
import com.socialize.ui.auth.AuthPanelView;
import com.socialize.ui.auth.IAuthDialogFactory;
import com.socialize.ui.profile.UserSettings;
import com.socialize.ui.share.DialogFlowController;
import com.socialize.ui.share.IShareDialogFactory;
import com.socialize.ui.share.ShareDialogListener;
import com.socialize.ui.share.SharePanelView;

public class SocializeLikeUtils
extends SocializeActionUtilsBase
implements LikeUtilsProxy {
    private IAuthDialogFactory authDialogFactory;
    private IShareDialogFactory shareDialogFactory;
    private LikeSystem likeSystem;

    @Override
    public void like(Activity context, Entity entity, LikeAddListener listener) {
        this.like(context, entity, this.getUserLikeOptions((Context)context), listener, new SocialNetwork[0]);
    }

    @Override
    public void like(Activity context, final Entity entity, final LikeOptions likeOptions, final LikeAddListener listener, final SocialNetwork ... networks) {
        try {
            final boolean doShare = this.isDisplayShareDialog((Context)context, likeOptions);
            final SocializeSession session = this.getSocialize().getSession();
            if (this.isDisplayAuthDialog((Context)context, session, likeOptions, networks)) {
                this.authDialogFactory.show((Context)context, new AuthDialogListener(){

                    @Override
                    public void onShow(Dialog dialog, AuthPanelView dialogView) {
                    }

                    @Override
                    public void onCancel(Dialog dialog) {
                        if (listener != null) {
                            listener.onCancel();
                        }
                    }

                    @Override
                    public void onSkipAuth(Activity context, Dialog dialog) {
                        dialog.dismiss();
                        SocializeLikeUtils.this.doLikeWithoutShareDialog(context, session, entity, likeOptions, listener, new SocialNetwork[0]);
                    }

                    @Override
                    public void onError(Activity context, Dialog dialog, Exception error) {
                        dialog.dismiss();
                        if (listener != null) {
                            listener.onError(SocializeException.wrap(error));
                        }
                    }

                    @Override
                    public void onAuthenticate(Activity context, Dialog dialog, SocialNetwork network) {
                        dialog.dismiss();
                        try {
                            if (doShare) {
                                SocializeLikeUtils.this.doLikeWithShareDialog(context, session, entity, likeOptions, listener);
                            } else if (networks == null || networks.length == 0) {
                                SocializeLikeUtils.this.doLikeWithoutShareDialog(context, session, entity, likeOptions, listener, UserUtils.getAutoPostSocialNetworks((Context)context));
                            } else {
                                SocializeLikeUtils.this.doLikeWithoutShareDialog(context, session, entity, likeOptions, listener, networks);
                            }
                        }
                        catch (SocializeException e) {
                            if (listener != null) {
                                listener.onError(e);
                            }
                            Log.e((String)SocializeLogger.LOG_TAG, (String)"Error adding like", (Throwable)e);
                        }
                    }
                }, !this.config.isAllowSkipAuthOnAllActions());
            } else if (doShare) {
                this.doLikeWithShareDialog(context, session, entity, likeOptions, listener);
            } else if (networks == null || networks.length == 0) {
                this.doLikeWithoutShareDialog(context, session, entity, likeOptions, listener, UserUtils.getAutoPostSocialNetworks((Context)context));
            } else {
                this.doLikeWithoutShareDialog(context, session, entity, likeOptions, listener, networks);
            }
        }
        catch (Throwable e) {
            if (listener != null) {
                listener.onError(SocializeException.wrap(e));
            }
            Log.e((String)SocializeLogger.LOG_TAG, (String)"Error adding like", (Throwable)e);
        }
    }

    @Override
    public LikeOptions getUserLikeOptions(Context context) {
        LikeOptions options = new LikeOptions();
        this.populateActionOptions(context, options);
        return options;
    }

    protected void doLikeWithoutShareDialog(Activity context, SocializeSession session, Entity entity, LikeAddListener listener) throws SocializeException {
        this.doLikeWithoutShareDialog(context, session, entity, this.getUserLikeOptions((Context)context), listener, UserUtils.getAutoPostSocialNetworks((Context)context));
    }

    protected void doLikeWithoutShareDialog(final Activity context, SocializeSession session, Entity entity, LikeOptions likeOptions, final LikeAddListener listener, final SocialNetwork ... networks) {
        this.likeSystem.addLike(session, entity, likeOptions, new LikeAddListener(){

            @Override
            public void onError(SocializeException error) {
                if (listener != null) {
                    listener.onError(error);
                }
            }

            @Override
            public void onCreate(Like like) {
                if (listener != null) {
                    listener.onCreate(like);
                }
                if (networks != null) {
                    SocializeLikeUtils.this.doActionShare(context, like, null, listener, networks);
                }
            }
        }, networks);
    }

    protected void doLikeWithShareDialog(final Activity context, final SocializeSession session, final Entity entity, final LikeOptions likeOptions, final LikeAddListener listener) throws SocializeException {
        if (this.isDisplayShareDialog((Context)context, likeOptions)) {
            this.shareDialogFactory.show((Context)context, entity, null, new ShareDialogListener(){

                @Override
                public void onShow(Dialog dialog, SharePanelView dialogView) {
                }

                @Override
                public void onFlowInterrupted(DialogFlowController controller) {
                }

                @Override
                public void onSimpleShare(ShareType type) {
                }

                @Override
                public boolean onContinue(final Dialog dialog, boolean remember, final SocialNetwork ... networks) {
                    UserSettings settings = session.getUserSettings();
                    if (remember && settings.setAutoPostPreferences(networks)) {
                        UserUtils.saveUserSettings((Context)context, settings, null);
                    }
                    LikeAddListener overrideListener = new LikeAddListener(){

                        @Override
                        public void onError(SocializeException error) {
                            if (dialog != null) {
                                dialog.dismiss();
                            }
                            if (listener != null) {
                                listener.onError(error);
                            }
                        }

                        @Override
                        public void onCreate(Like like) {
                            if (listener != null) {
                                listener.onCreate(like);
                            }
                            SocializeLikeUtils.this.doActionShare(context, like, null, listener, networks);
                            if (dialog != null) {
                                dialog.dismiss();
                            }
                        }
                    };
                    SocializeLikeUtils.this.likeSystem.addLike(session, entity, likeOptions, overrideListener, networks);
                    return false;
                }

                @Override
                public void onCancel(Dialog dialog) {
                    if (listener != null) {
                        listener.onCancel();
                    }
                }
            }, 220);
        } else {
            this.doLikeWithoutShareDialog(context, session, entity, listener);
        }
    }

    @Override
    public void unlike(Activity context, String entityKey, final LikeDeleteListener listener) {
        final SocializeSession session = this.getSocialize().getSession();
        this.likeSystem.getLike(session, entityKey, (LikeListener)new LikeGetListener(){

            @Override
            public void onGet(Like entity) {
                if (entity != null) {
                    SocializeLikeUtils.this.likeSystem.deleteLike(session, entity.getId(), listener);
                } else if (listener != null) {
                    listener.onDelete();
                }
            }

            @Override
            public void onError(SocializeException error) {
                if (error instanceof SocializeApiError && ((SocializeApiError)error).getResultCode() == 404) {
                    if (listener != null) {
                        listener.onDelete();
                    }
                    return;
                }
                if (listener != null) {
                    listener.onError(error);
                }
            }
        });
    }

    @Override
    public void getLike(Activity context, String entityKey, LikeGetListener listener) {
        SocializeSession session = this.getSocialize().getSession();
        this.likeSystem.getLike(session, entityKey, (LikeListener)listener);
    }

    @Override
    public void getLike(Activity context, long id, LikeGetListener listener) {
        SocializeSession session = this.getSocialize().getSession();
        this.likeSystem.getLike(session, id, (LikeListener)listener);
    }

    @Override
    public void getLikesByUser(Activity context, User user, int start, int end, LikeListListener listener) {
        SocializeSession session = this.getSocialize().getSession();
        this.likeSystem.getLikesByUser(session, user.getId(), start, end, listener);
    }

    @Override
    public void getLikesByEntity(Activity context, String entityKey, int start, int end, LikeListListener listener) {
        this.likeSystem.getLikesByEntity(this.getSocialize().getSession(), entityKey, start, end, listener);
    }

    @Override
    public void getLikesByApplication(Activity context, int start, int end, LikeListListener listener) {
        this.likeSystem.getLikesByApplication(this.getSocialize().getSession(), start, end, listener);
    }

    public void setAuthDialogFactory(IAuthDialogFactory authDialogFactory) {
        this.authDialogFactory = authDialogFactory;
    }

    public void setShareDialogFactory(IShareDialogFactory shareDialogFactory) {
        this.shareDialogFactory = shareDialogFactory;
    }

    public void setLikeSystem(LikeSystem likeSystem) {
        this.likeSystem = likeSystem;
    }

    @Override
    public void makeLikeButton(final Activity context, final CompoundButton button, final Entity entity, final LikeButtonListener listener) {
        if (listener != null) {
            button.setOnCheckedChangeListener(null);
        }
        button.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (listener != null) {
                    listener.onClick(button);
                }
                if (button.isChecked()) {
                    LikeUtils.like(context, entity, new LikeAddListener(){

                        @Override
                        public void onError(SocializeException error) {
                            button.setChecked(false);
                            if (listener != null) {
                                listener.onError(button, error);
                            }
                        }

                        @Override
                        public void onCreate(Like result) {
                            if (listener != null) {
                                listener.onCheckedChanged(button, true);
                            }
                        }

                        @Override
                        public void onCancel() {
                            button.setChecked(false);
                            if (listener != null) {
                                listener.onCheckedChanged(button, false);
                            }
                        }
                    });
                } else {
                    LikeUtils.unlike(context, entity.getKey(), new LikeDeleteListener(){

                        @Override
                        public void onError(SocializeException error) {
                            button.setChecked(true);
                            if (listener != null) {
                                listener.onError(button, error);
                            }
                        }

                        @Override
                        public void onDelete() {
                            button.setChecked(false);
                            if (listener != null) {
                                listener.onCheckedChanged(button, false);
                            }
                        }
                    });
                }
            }
        });
        LikeUtils.isLiked(context, entity.getKey(), new IsLikedListener(){

            @Override
            public void onNotLiked() {
                button.setChecked(false);
                if (listener != null) {
                    listener.onCheckedChanged(button, false);
                }
            }

            @Override
            public void onLiked(Like like) {
                button.setChecked(true);
                if (listener != null) {
                    listener.onCheckedChanged(button, true);
                }
            }
        });
    }
}

