/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.api.action.like;

import com.socialize.api.SocializeApi;
import com.socialize.api.SocializeSession;
import com.socialize.api.action.like.LikeOptions;
import com.socialize.api.action.like.LikeSystem;
import com.socialize.entity.Entity;
import com.socialize.entity.Like;
import com.socialize.entity.User;
import com.socialize.error.SocializeApiError;
import com.socialize.error.SocializeException;
import com.socialize.listener.SocializeActionListener;
import com.socialize.listener.like.LikeListListener;
import com.socialize.listener.like.LikeListener;
import com.socialize.networks.SocialNetwork;
import com.socialize.provider.SocializeProvider;
import java.util.ArrayList;
import java.util.List;

public class SocializeLikeSystem
extends SocializeApi<Like, SocializeProvider<Like>>
implements LikeSystem {
    public SocializeLikeSystem(SocializeProvider<Like> provider) {
        super(provider);
    }

    @Override
    public void addLike(SocializeSession session, Entity entity, LikeOptions shareOptions, LikeListener listener, SocialNetwork ... networks) {
        Like c = new Like();
        c.setEntitySafe(entity);
        this.setPropagationData(c, shareOptions, networks);
        this.setLocation(c);
        ArrayList<Like> list = new ArrayList<Like>(1);
        list.add(c);
        this.postAsync(session, "/like/", list, (SocializeActionListener)listener);
    }

    @Override
    public void deleteLike(SocializeSession session, long id, LikeListener listener) {
        this.deleteAsync(session, "/like/", String.valueOf(id), listener);
    }

    @Override
    public void getLikesByEntity(SocializeSession session, String key, LikeListener listener) {
        this.listAsync(session, "/like/", key, listener, new String[0]);
    }

    @Override
    public void getLikesByUser(SocializeSession session, long userId, LikeListener listener) {
        String endpoint = "/user/" + userId + "/like/";
        this.listAsync(session, endpoint, listener);
    }

    @Override
    public void getLikesByUser(SocializeSession session, long userId, int startIndex, int endIndex, LikeListener listener) {
        String endpoint = "/user/" + userId + "/like/";
        this.listAsync(session, endpoint, startIndex, endIndex, listener);
    }

    @Override
    public void getLikesByEntity(SocializeSession session, String key, int startIndex, int endIndex, LikeListener listener) {
        this.listAsync(session, "/like/", key, null, null, startIndex, endIndex, listener, new String[0]);
    }

    @Override
    public void getLikesByApplication(SocializeSession session, int startIndex, int endIndex, LikeListener listener) {
        this.listAsync(session, "/like/", null, null, null, startIndex, endIndex, listener, new String[0]);
    }

    @Override
    public void getLike(SocializeSession session, final String entityUrl, final LikeListener listener) {
        User user = session.getUser();
        if (user != null) {
            final Long userId = user.getId();
            String endpoint = "/user/" + userId.toString() + "/like/";
            this.listAsync(session, endpoint, entityUrl, null, null, 0, 1, new LikeListListener(){

                @Override
                public void onList(List<Like> items, int totalSize) {
                    boolean is404 = false;
                    if (items != null) {
                        if (items != null && items.size() > 0) {
                            Like like = items.get(0);
                            if (like != null) {
                                listener.onGet(like);
                            } else {
                                is404 = true;
                            }
                        } else {
                            is404 = true;
                        }
                    } else {
                        is404 = true;
                    }
                    if (is404) {
                        this.onError(new SocializeApiError(404, "No likes found for entity with key [" + entityUrl + "] for user [" + userId + "]"));
                    }
                }

                @Override
                public void onError(SocializeException error) {
                    listener.onError(error);
                }
            }, new String[0]);
        } else if (listener != null) {
            listener.onError(new SocializeException("No user found in current session"));
        }
    }

    @Override
    public void getLikesById(SocializeSession session, LikeListener listener, long ... ids) {
        if (ids != null) {
            String[] strIds = new String[ids.length];
            for (int i = 0; i < ids.length; ++i) {
                strIds[i] = String.valueOf(ids[i]);
            }
            this.listAsync(session, "/like/", null, 0, 100, listener, strIds);
        } else if (listener != null) {
            listener.onError(new SocializeException("No ids supplied"));
        }
    }

    @Override
    public void getLike(SocializeSession session, long id, LikeListener listener) {
        this.getAsync(session, "/like/", String.valueOf(id), listener);
    }
}

