/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.api.action.entity;

import com.socialize.EntityUtils;
import com.socialize.api.SocializeApi;
import com.socialize.api.SocializeSession;
import com.socialize.api.action.entity.EntitySystem;
import com.socialize.entity.Entity;
import com.socialize.entity.ListResult;
import com.socialize.entity.SocializeObject;
import com.socialize.error.SocializeApiError;
import com.socialize.error.SocializeException;
import com.socialize.listener.SocializeActionListener;
import com.socialize.listener.entity.EntityListListener;
import com.socialize.listener.entity.EntityListener;
import com.socialize.provider.SocializeProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SocializeEntitySystem
extends SocializeApi<Entity, SocializeProvider<Entity>>
implements EntitySystem {
    public SocializeEntitySystem(SocializeProvider<Entity> provider) {
        super(provider);
    }

    @Override
    public Entity getEntitySynchronous(SocializeSession session, long id) throws SocializeException {
        List items;
        ListResult list = this.list(session, "/entity/", null, 0, 1, String.valueOf(id));
        if (list != null && (items = list.getItems()) != null && items.size() > 0) {
            return (Entity)items.get(0);
        }
        return null;
    }

    @Override
    public void addEntity(SocializeSession session, Entity entity, EntityListener listener) {
        ArrayList<Entity> list = new ArrayList<Entity>(1);
        list.add(entity);
        this.postAsync(session, "/entity/", list, (SocializeActionListener)listener);
    }

    protected EntityListListener getListenerForGet(final EntityListener listener, final String notFoundMessage) {
        return new EntityListListener(){

            @Override
            public void onError(SocializeException error) {
                listener.onError(error);
            }

            @Override
            public void onList(ListResult<Entity> entities) {
                boolean is404 = false;
                if (entities != null) {
                    List<Entity> items = entities.getItems();
                    if (items != null && items.size() > 0) {
                        listener.onGet((SocializeObject)items.get(0));
                    } else {
                        is404 = true;
                    }
                } else {
                    is404 = true;
                }
                if (is404) {
                    this.onError(new SocializeApiError(404, notFoundMessage));
                }
            }
        };
    }

    @Override
    public void getEntity(SocializeSession session, long id, EntityListener listener) {
        this.listAsync(session, "/entity/", null, 0, 1, this.getListenerForGet(listener, "No entity found with id [" + id + "]"), String.valueOf(id));
    }

    @Override
    public void getEntity(SocializeSession session, String key, EntityListener listener) {
        this.listAsync(session, "/entity/", key, null, null, 0, 1, this.getListenerForGet(listener, "No entity found with key [" + key + "]"), new String[0]);
    }

    @Override
    public void getEntities(SocializeSession session, EntityUtils.SortOrder sortOrder, EntityListener listener, String ... keys) {
        HashMap<String, String> extraParams = null;
        if (!sortOrder.equals((Object)EntityUtils.SortOrder.CREATION_DATE)) {
            extraParams = new HashMap<String, String>();
            extraParams.put("sort", sortOrder.name().toLowerCase());
        }
        this.listAsync(session, "/entity/", null, "entity_key", extraParams, 0, 100, listener, keys);
    }

    @Override
    public void getEntities(SocializeSession session, int start, int end, EntityUtils.SortOrder sortOrder, EntityListener listener) {
        HashMap<String, String> extraParams = null;
        if (!sortOrder.equals((Object)EntityUtils.SortOrder.CREATION_DATE)) {
            extraParams = new HashMap<String, String>();
            extraParams.put("sort", sortOrder.name().toLowerCase());
        }
        this.listAsync(session, "/entity/", null, "entity_key", extraParams, start, end, listener, new String[0]);
    }
}

