/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.api.action.comment;

import com.socialize.api.SocializeApi;
import com.socialize.api.SocializeSession;
import com.socialize.api.action.comment.SubscriptionSystem;
import com.socialize.entity.Entity;
import com.socialize.entity.Subscription;
import com.socialize.listener.SocializeActionListener;
import com.socialize.listener.subscription.SubscriptionListener;
import com.socialize.notifications.NotificationType;
import com.socialize.provider.SocializeProvider;
import java.util.ArrayList;

public class SocializeSubscriptionSystem
extends SocializeApi<Subscription, SocializeProvider<Subscription>>
implements SubscriptionSystem {
    public SocializeSubscriptionSystem(SocializeProvider<Subscription> provider) {
        super(provider);
    }

    @Override
    public void getSubscription(SocializeSession session, Entity entity, NotificationType type, SubscriptionListener listener) {
        this.getByEntityAsync(session, "/user/subscription/", entity.getKey(), listener);
    }

    @Override
    public void listSubscriptions(SocializeSession session, SubscriptionListener listener) {
        this.listAsync(session, "/user/subscription/", listener);
    }

    @Override
    public void listSubscriptions(SocializeSession session, int startIndex, int endIndex, SubscriptionListener listener) {
        this.listAsync(session, "/user/subscription/", startIndex, endIndex, listener);
    }

    @Override
    public void addSubscription(SocializeSession session, Entity entity, NotificationType type, SubscriptionListener listener) {
        this.doSubscribe(session, entity, type, listener, true);
    }

    @Override
    public void removeSubscription(SocializeSession session, Entity entity, NotificationType type, SubscriptionListener listener) {
        this.doSubscribe(session, entity, type, listener, false);
    }

    protected void doSubscribe(SocializeSession session, Entity entity, NotificationType type, SubscriptionListener listener, boolean subscribed) {
        Subscription c = new Subscription();
        c.setUser(session.getUser());
        c.setEntity(entity);
        c.setSubscribed(subscribed);
        c.setNotificationType(type);
        ArrayList<Subscription> list = new ArrayList<Subscription>(1);
        list.add(c);
        this.postAsync(session, "/user/subscription/", list, (SocializeActionListener)listener);
    }
}

