/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.api.action.comment;

import android.app.Activity;
import android.app.Dialog;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.util.Log;
import com.socialize.UserUtils;
import com.socialize.android.ioc.Container;
import com.socialize.api.SocializeSession;
import com.socialize.api.action.ShareType;
import com.socialize.api.action.SocializeActionUtilsBase;
import com.socialize.api.action.comment.CommentOptions;
import com.socialize.api.action.comment.CommentSystem;
import com.socialize.api.action.comment.CommentUtilsProxy;
import com.socialize.entity.Comment;
import com.socialize.entity.Entity;
import com.socialize.entity.User;
import com.socialize.error.SocializeException;
import com.socialize.listener.ListenerHolder;
import com.socialize.listener.comment.CommentAddListener;
import com.socialize.listener.comment.CommentDeleteListener;
import com.socialize.listener.comment.CommentGetListener;
import com.socialize.listener.comment.CommentListListener;
import com.socialize.log.SocializeLogger;
import com.socialize.networks.SocialNetwork;
import com.socialize.ui.auth.AuthDialogListener;
import com.socialize.ui.auth.AuthPanelView;
import com.socialize.ui.auth.IAuthDialogFactory;
import com.socialize.ui.comment.CommentActivity;
import com.socialize.ui.comment.OnCommentViewActionListener;
import com.socialize.ui.profile.UserSettings;
import com.socialize.ui.share.DialogFlowController;
import com.socialize.ui.share.IShareDialogFactory;
import com.socialize.ui.share.ShareDialogListener;
import com.socialize.ui.share.SharePanelView;
import java.io.Serializable;

public class SocializeCommentUtils
extends SocializeActionUtilsBase
implements CommentUtilsProxy {
    private CommentSystem commentSystem;
    private IAuthDialogFactory authDialogFactory;
    private IShareDialogFactory shareDialogFactory;
    private ListenerHolder listenerHolder;
    private Container container;
    private SocializeLogger logger;

    public void onCreate(Container container) {
        this.container = container;
    }

    public void onDestroy(Container container) {
        this.container = null;
    }

    @Override
    public void showCommentView(Activity context, Entity entity) {
        this.showCommentView(context, entity, null);
    }

    @Override
    public void preloadCommentView(Activity context) {
        if (this.container != null) {
            this.container.getBean("commentList");
        }
    }

    @Override
    public void showCommentView(Activity context, Entity entity, OnCommentViewActionListener listener) {
        if (listener != null && this.listenerHolder != null) {
            this.listenerHolder.push("socialize.comment.listener", listener);
        }
        try {
            Intent i = this.newIntent(context, CommentActivity.class);
            i.putExtra("socialize.entity", (Serializable)entity);
            context.startActivity(i);
        }
        catch (ActivityNotFoundException e) {
            this.logger.error("Could not find CommentActivity.  Make sure you have added this to your AndroidManifest.xml");
        }
    }

    @Override
    public CommentOptions getUserCommentOptions(Context context) {
        CommentOptions options = new CommentOptions();
        this.populateActionOptions(context, options);
        options.setSubscribeToUpdates(true);
        return options;
    }

    @Override
    public void deleteComment(Activity context, long id, CommentDeleteListener listener) {
        this.commentSystem.deleteComment(this.getSocialize().getSession(), id, listener);
    }

    @Override
    public void addComment(Activity context, Entity entity, String text, CommentAddListener listener) {
        this.addComment(context, entity, text, this.getUserCommentOptions((Context)context), listener, new SocialNetwork[0]);
    }

    @Override
    public void addComment(Activity context, final Entity entity, final String text, final CommentOptions commentOptions, final CommentAddListener listener, final SocialNetwork ... networks) {
        try {
            final boolean doShare = this.isDisplayShareDialog((Context)context, commentOptions);
            final SocializeSession session = this.getSocialize().getSession();
            if (this.isDisplayAuthDialog((Context)context, session, commentOptions, networks)) {
                this.authDialogFactory.show((Context)context, new AuthDialogListener(){

                    @Override
                    public void onShow(Dialog dialog, AuthPanelView dialogView) {
                    }

                    @Override
                    public void onCancel(Dialog dialog) {
                        if (listener != null) {
                            listener.onCancel();
                        }
                    }

                    @Override
                    public void onSkipAuth(Activity context, Dialog dialog) {
                        dialog.dismiss();
                        try {
                            SocializeCommentUtils.this.doCommentWithoutShareDialog(context, session, entity, text, commentOptions, listener);
                        }
                        catch (SocializeException e) {
                            if (listener != null) {
                                listener.onError(e);
                            }
                            if (SocializeCommentUtils.this.logger != null) {
                                SocializeCommentUtils.this.logger.error("Error adding comment", (Throwable)e);
                            }
                            Log.e((String)SocializeLogger.LOG_TAG, (String)"Error adding comment", (Throwable)e);
                        }
                    }

                    @Override
                    public void onError(Activity context, Dialog dialog, Exception error) {
                        dialog.dismiss();
                        if (listener != null) {
                            listener.onError(SocializeException.wrap(error));
                        }
                    }

                    @Override
                    public void onAuthenticate(Activity context, Dialog dialog, SocialNetwork network) {
                        dialog.dismiss();
                        try {
                            if (doShare) {
                                SocializeCommentUtils.this.doCommentWithShareDialog(context, session, entity, text, commentOptions, listener);
                            } else if (networks == null || networks.length == 0) {
                                SocializeCommentUtils.this.doCommentWithoutShareDialog(context, session, entity, text, commentOptions, listener, UserUtils.getAutoPostSocialNetworks((Context)context));
                            } else {
                                SocializeCommentUtils.this.doCommentWithoutShareDialog(context, session, entity, text, commentOptions, listener, networks);
                            }
                        }
                        catch (SocializeException e) {
                            if (listener != null) {
                                listener.onError(e);
                            }
                            if (SocializeCommentUtils.this.logger != null) {
                                SocializeCommentUtils.this.logger.error("Error adding comment", (Throwable)e);
                            }
                            Log.e((String)SocializeLogger.LOG_TAG, (String)"Error adding comment", (Throwable)e);
                        }
                    }
                }, !this.config.isAllowSkipAuthOnComments() || !this.config.isAllowSkipAuthOnAllActions());
            } else if (doShare) {
                this.doCommentWithShareDialog(context, session, entity, text, commentOptions, listener);
            } else if (networks == null || networks.length == 0) {
                this.doCommentWithoutShareDialog(context, session, entity, text, commentOptions, listener, UserUtils.getAutoPostSocialNetworks((Context)context));
            } else {
                this.doCommentWithoutShareDialog(context, session, entity, text, commentOptions, listener, networks);
            }
        }
        catch (Throwable e) {
            if (listener != null) {
                listener.onError(SocializeException.wrap(e));
            }
            if (this.logger != null) {
                this.logger.error("Error adding comment", e);
            }
            Log.e((String)SocializeLogger.LOG_TAG, (String)"Error adding comment", (Throwable)e);
        }
    }

    protected void doCommentWithShareDialog(final Activity context, final SocializeSession session, final Entity entity, final String text, final CommentOptions commentOptions, final CommentAddListener listener) throws SocializeException {
        if (this.isDisplayShareDialog((Context)context, commentOptions)) {
            this.shareDialogFactory.show((Context)context, entity, null, new ShareDialogListener(){

                @Override
                public void onShow(Dialog dialog, SharePanelView dialogView) {
                }

                @Override
                public void onFlowInterrupted(DialogFlowController controller) {
                }

                @Override
                public void onSimpleShare(ShareType type) {
                }

                @Override
                public boolean onContinue(final Dialog dialog, boolean remember, final SocialNetwork ... networks) {
                    UserSettings settings = session.getUserSettings();
                    if (remember && settings.setAutoPostPreferences(networks)) {
                        UserUtils.saveUserSettings((Context)context, settings, null);
                    }
                    CommentAddListener overrideListener = new CommentAddListener(){

                        @Override
                        public void onError(SocializeException error) {
                            dialog.dismiss();
                            if (listener != null) {
                                listener.onError(error);
                            }
                        }

                        @Override
                        public void onCreate(Comment comment) {
                            if (listener != null) {
                                listener.onCreate(comment);
                            }
                            SocializeCommentUtils.this.doActionShare(context, comment, text, listener, networks);
                            dialog.dismiss();
                        }
                    };
                    SocializeCommentUtils.this.commentSystem.addComment(session, entity, text, commentOptions, overrideListener, networks);
                    return false;
                }

                @Override
                public void onCancel(Dialog dialog) {
                    if (listener != null) {
                        listener.onCancel();
                    }
                }
            }, 220);
        } else {
            this.doCommentWithoutShareDialog(context, session, entity, text, commentOptions, listener);
        }
    }

    protected void doCommentWithoutShareDialog(Activity context, SocializeSession session, Entity entity, String text, CommentOptions commentOptions, CommentAddListener listener) throws SocializeException {
        this.doCommentWithoutShareDialog(context, session, entity, text, commentOptions, listener, UserUtils.getAutoPostSocialNetworks((Context)context));
    }

    protected void doCommentWithoutShareDialog(final Activity context, SocializeSession session, Entity entity, final String text, CommentOptions commentOptions, final CommentAddListener listener, final SocialNetwork ... networks) {
        this.commentSystem.addComment(session, entity, text, commentOptions, new CommentAddListener(){

            @Override
            public void onError(SocializeException error) {
                if (listener != null) {
                    listener.onError(error);
                }
            }

            @Override
            public void onCreate(Comment comment) {
                if (listener != null) {
                    listener.onCreate(comment);
                }
                if (networks != null && networks.length > 0) {
                    SocializeCommentUtils.this.doActionShare(context, comment, text, listener, networks);
                }
            }
        }, networks);
    }

    protected Intent newIntent(Activity context, Class<?> cls) {
        return new Intent((Context)context, cls);
    }

    @Override
    public void getComment(Activity context, long id, CommentGetListener listener) {
        this.commentSystem.getComment(this.getSocialize().getSession(), id, listener);
    }

    @Override
    public void getComments(Activity context, CommentListListener listener, long ... ids) {
        this.commentSystem.getCommentsById(this.getSocialize().getSession(), listener, ids);
    }

    @Override
    public void getCommentsByUser(Activity context, User user, int start, int end, CommentListListener listener) {
        this.commentSystem.getCommentsByUser(this.getSocialize().getSession(), user.getId(), start, end, listener);
    }

    @Override
    public void getCommentsByEntity(Activity context, String entityKey, int start, int end, CommentListListener listener) {
        this.commentSystem.getCommentsByEntity(this.getSocialize().getSession(), entityKey, start, end, listener);
    }

    @Override
    public void getCommentsByApplication(Activity context, int start, int end, CommentListListener listener) {
        this.commentSystem.getCommentsByApplication(this.getSocialize().getSession(), start, end, listener);
    }

    public void setCommentSystem(CommentSystem commentSystem) {
        this.commentSystem = commentSystem;
    }

    public void setAuthDialogFactory(IAuthDialogFactory authDialogFactory) {
        this.authDialogFactory = authDialogFactory;
    }

    public void setShareDialogFactory(IShareDialogFactory shareDialogFactory) {
        this.shareDialogFactory = shareDialogFactory;
    }

    public void setListenerHolder(ListenerHolder listenerHolder) {
        this.listenerHolder = listenerHolder;
    }

    public void setLogger(SocializeLogger logger) {
        this.logger = logger;
    }
}

