/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.api.action.activity;

import com.socialize.api.SocializeApi;
import com.socialize.api.SocializeSession;
import com.socialize.api.action.ActionType;
import com.socialize.api.action.activity.ActivitySystem;
import com.socialize.entity.SocializeAction;
import com.socialize.error.SocializeException;
import com.socialize.listener.activity.ActionListener;
import com.socialize.provider.SocializeProvider;

public class SocializeActivitySystem
extends SocializeApi<SocializeAction, SocializeProvider<SocializeAction>>
implements ActivitySystem {
    public SocializeActivitySystem(SocializeProvider<SocializeAction> provider) {
        super(provider);
    }

    @Override
    public SocializeAction getAction(SocializeSession session, long id, ActionType type) throws SocializeException {
        String endpoint = null;
        switch (type) {
            case COMMENT: {
                endpoint = "/comment/";
                break;
            }
            case LIKE: {
                endpoint = "/like/";
                break;
            }
            case SHARE: {
                endpoint = "/share/";
                break;
            }
            case VIEW: {
                endpoint = "/view/";
            }
        }
        return (SocializeAction)this.get(session, endpoint, String.valueOf(id), type);
    }

    @Override
    public void getActivityByUser(SocializeSession session, long id, ActionListener listener) {
        String userId = String.valueOf(id);
        String endpoint = this.getEndpoint(userId);
        this.listAsync(session, endpoint, listener);
    }

    @Override
    public void getActivityByUser(SocializeSession session, long id, int startIndex, int endIndex, ActionListener listener) {
        String userId = String.valueOf(id);
        String endpoint = this.getEndpoint(userId);
        this.listAsync(session, endpoint, startIndex, endIndex, listener);
    }

    @Override
    public void getActivityByUserAndEntity(SocializeSession session, long userId, String entityKey, int startIndex, int endIndex, ActionListener listener) {
        String strId = String.valueOf(userId);
        String endpoint = this.getEndpoint(strId);
        this.listAsync(session, endpoint, entityKey, startIndex, endIndex, listener, new String[0]);
    }

    @Override
    public void getActivityByApplication(SocializeSession session, int startIndex, int endIndex, ActionListener listener) {
        this.listAsync(session, "/activity/", startIndex, endIndex, listener);
    }

    @Override
    public void getActivityByEntity(SocializeSession session, String entityKey, int startIndex, int endIndex, ActionListener listener) {
        this.listAsync(session, "/activity/", entityKey, startIndex, endIndex, listener, new String[0]);
    }

    protected String getEndpoint(String id) {
        return "/user/" + id + "/activity/";
    }
}

