/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.api.action;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import com.socialize.ConfigUtils;
import com.socialize.Socialize;
import com.socialize.SocializeService;
import com.socialize.UserUtils;
import com.socialize.api.SocializeSession;
import com.socialize.api.action.ActionOptions;
import com.socialize.api.action.ShareType;
import com.socialize.api.action.ShareableActionOptions;
import com.socialize.auth.AuthProviderType;
import com.socialize.config.SocializeConfig;
import com.socialize.entity.SocializeAction;
import com.socialize.error.SocializeException;
import com.socialize.log.SocializeLogger;
import com.socialize.networks.PostData;
import com.socialize.networks.SocialNetwork;
import com.socialize.networks.SocialNetworkListener;
import com.socialize.networks.facebook.FacebookUtils;
import com.socialize.networks.twitter.TwitterUtils;
import com.socialize.share.ShareHandler;
import com.socialize.share.ShareHandlers;
import com.socialize.ui.profile.UserSettings;
import org.json.JSONObject;

public abstract class SocializeActionUtilsBase {
    private ShareHandlers shareHandlers;
    protected SocializeConfig config;

    protected void populateActionOptions(Context context, ActionOptions options) {
        if (this.config == null) {
            options.setShowAuthDialog(ConfigUtils.getConfig(context).isPromptForAuth());
        } else {
            options.setShowAuthDialog(this.config.isPromptForAuth());
        }
    }

    protected boolean isDisplayAuthDialog(Context context, SocializeSession session, ActionOptions options, SocialNetwork ... networks) {
        boolean authRequired = true;
        boolean authSupported = false;
        if (options != null) {
            authRequired = options.isShowAuthDialog();
        }
        if (authRequired) {
            authRequired = session.getUserSettings().isShowAuthDialog();
        }
        if (networks == null || networks.length == 0) {
            networks = new SocialNetwork[]{SocialNetwork.TWITTER, SocialNetwork.FACEBOOK};
        }
        if (authRequired) {
            for (SocialNetwork network : networks) {
                AuthProviderType type = AuthProviderType.valueOf(network);
                if (this.getSocialize().isSupported(context, type)) {
                    authSupported = true;
                    if (this.getSocialize().isAuthenticatedForRead(type, new String[0])) {
                        authRequired = false;
                        break;
                    }
                }
                if (!authRequired) break;
            }
        }
        return authRequired && authSupported;
    }

    protected boolean isDisplayShareDialog(Context context, ShareableActionOptions options) {
        if ((options == null || options.isShowShareDialog()) && ConfigUtils.getConfig(context).isPromptForShare()) {
            boolean shareRequired;
            boolean fbSupported = FacebookUtils.isAvailable(context);
            boolean twSupported = TwitterUtils.isAvailable(context);
            boolean bl = shareRequired = fbSupported || twSupported;
            if (shareRequired) {
                try {
                    UserSettings settings = UserUtils.getUserSettings(context);
                    if (shareRequired && fbSupported) {
                        shareRequired &= !settings.isAutoPostFacebook();
                    }
                    if (shareRequired && twSupported) {
                        shareRequired &= !settings.isAutoPostTwitter();
                    }
                }
                catch (SocializeException e) {
                    Log.e((String)SocializeLogger.LOG_TAG, (String)"Error getting user settings", (Throwable)e);
                    shareRequired = false;
                }
            }
            return shareRequired;
        }
        return false;
    }

    protected SocializeService getSocialize() {
        return Socialize.getSocialize();
    }

    protected void doActionShare(Activity context, SocializeAction action, String text, final SocialNetworkListener listener, SocialNetwork ... networks) {
        if (networks != null && networks.length > 0) {
            for (SocialNetwork socialNetwork : networks) {
                ShareHandler handler = this.shareHandlers.getShareHandler(ShareType.valueOf(socialNetwork));
                if (handler != null) {
                    handler.handle(context, action, null, text, new SocialNetworkListener(){

                        @Override
                        public void onNetworkError(Activity context, SocialNetwork network, Exception error) {
                            if (listener != null) {
                                listener.onNetworkError(context, network, error);
                            }
                        }

                        @Override
                        public void onCancel() {
                            if (listener != null) {
                                listener.onCancel();
                            }
                        }

                        @Override
                        public boolean onBeforePost(Activity parent, SocialNetwork socialNetwork, PostData postData) {
                            if (listener != null) {
                                return listener.onBeforePost(parent, socialNetwork, postData);
                            }
                            return false;
                        }

                        @Override
                        public void onAfterPost(Activity parent, SocialNetwork socialNetwork, JSONObject responseObject) {
                            if (listener != null) {
                                listener.onAfterPost(parent, socialNetwork, responseObject);
                            }
                        }
                    });
                    continue;
                }
                System.err.println("No Handler found for network [" + (Object)((Object)socialNetwork) + "]");
            }
        }
    }

    public void setShareHandlers(ShareHandlers shareHandlers) {
        this.shareHandlers = shareHandlers;
    }

    public final void setConfig(SocializeConfig config) {
        this.config = config;
    }
}

