/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.api;

import android.content.Context;
import android.location.Location;
import com.socialize.Socialize;
import com.socialize.api.SocializeAuthRequest;
import com.socialize.api.SocializeAuthResponse;
import com.socialize.api.SocializeEntityResponse;
import com.socialize.api.SocializeGetRequest;
import com.socialize.api.SocializePutRequest;
import com.socialize.api.SocializeRequest;
import com.socialize.api.SocializeResponse;
import com.socialize.api.SocializeResponseFactory;
import com.socialize.api.SocializeSession;
import com.socialize.api.SocializeSessionConsumer;
import com.socialize.api.action.ActionOptions;
import com.socialize.api.action.ActionType;
import com.socialize.api.action.ShareType;
import com.socialize.auth.AuthProvider;
import com.socialize.auth.AuthProviderData;
import com.socialize.auth.AuthProviderInfo;
import com.socialize.auth.AuthProviderResponse;
import com.socialize.auth.AuthProviderType;
import com.socialize.auth.AuthProviders;
import com.socialize.concurrent.ManagedAsyncTask;
import com.socialize.config.SocializeConfig;
import com.socialize.entity.ActionError;
import com.socialize.entity.ListResult;
import com.socialize.entity.Propagation;
import com.socialize.entity.SocializeAction;
import com.socialize.entity.SocializeObject;
import com.socialize.error.SocializeException;
import com.socialize.listener.AuthProviderListener;
import com.socialize.listener.SocializeActionListener;
import com.socialize.listener.SocializeAuthListener;
import com.socialize.location.SocializeLocationProvider;
import com.socialize.log.SocializeLogger;
import com.socialize.networks.SocialNetwork;
import com.socialize.notifications.NotificationChecker;
import com.socialize.provider.SocializeProvider;
import com.socialize.ui.profile.UserSettings;
import com.socialize.util.AppUtils;
import com.socialize.util.HttpUtils;
import com.socialize.util.StringUtils;
import java.util.List;
import java.util.Map;

public class SocializeApi<T extends SocializeObject, P extends SocializeProvider<T>> {
    private P provider;
    private SocializeResponseFactory<T> responseFactory;
    private AuthProviders authProviders;
    private SocializeLogger logger;
    private HttpUtils httpUtils;
    private SocializeLocationProvider locationProvider;
    private NotificationChecker notificationChecker;
    private AppUtils appUtils;
    protected SocializeConfig config;

    public SocializeApi(P provider) {
        this.provider = provider;
    }

    public void clearSession() {
        this.provider.clearSession();
    }

    public void clearSession(AuthProviderType type) {
        this.provider.clearSession(type);
    }

    public SocializeSession loadSession(String endpoint, String key, String secret) throws SocializeException {
        return this.provider.loadSession(endpoint, key, secret);
    }

    public SocializeSession authenticate(Context context, String endpoint, String key, String secret, String uuid, String advertiserId) throws SocializeException {
        SocializeSession session = this.provider.authenticate(endpoint, key, secret, uuid, advertiserId);
        this.checkNotifications(context, session);
        return session;
    }

    public SocializeSession authenticate(Context context, String endpoint, String key, String secret, AuthProviderData data, String udid, String advertiserId) throws SocializeException {
        SocializeSession session = this.provider.authenticate(endpoint, key, secret, data, udid, advertiserId);
        this.checkNotifications(context, session);
        return session;
    }

    protected void checkNotifications(Context context, SocializeSession session) {
        if (this.notificationChecker != null) {
            this.notificationChecker.checkRegistrations(context, session);
        }
    }

    protected void setPropagationData(SocializeAction action, ActionOptions shareOptions, SocialNetwork ... networks) {
        boolean selfManaged;
        boolean bl = selfManaged = shareOptions == null ? false : shareOptions.isSelfManaged();
        if (networks != null) {
            Propagation propagation = null;
            Propagation localPropagation = null;
            for (SocialNetwork socialNetwork : networks) {
                if (socialNetwork.isLocalPropagation() || selfManaged) {
                    if (localPropagation == null) {
                        localPropagation = this.newPropagation();
                    }
                    localPropagation.addThirdParty(socialNetwork);
                    continue;
                }
                if (propagation == null) {
                    propagation = this.newPropagation();
                }
                propagation.addThirdParty(socialNetwork);
            }
            if (this.config != null) {
                String appStore = this.config.getProperty("redirect.app.store");
                if (!StringUtils.isEmpty(appStore)) {
                    String abbrev = this.appUtils.getAppStoreAbbreviation(appStore);
                    if (localPropagation != null) {
                        localPropagation.addExtraParam("f", abbrev);
                    }
                    if (propagation != null) {
                        propagation.addExtraParam("f", abbrev);
                    }
                }
                String ogAction = null;
                switch (action.getActionType()) {
                    case LIKE: {
                        if (!this.config.isOGLike()) break;
                        ogAction = "like";
                    }
                }
                if (ogAction != null) {
                    if (propagation != null) {
                        propagation.addExtraParam("og_action", ogAction);
                    }
                    if (localPropagation != null) {
                        localPropagation.addExtraParam("og_action", ogAction);
                    }
                }
            }
            action.setPropagation(propagation);
            action.setPropagationInfoRequest(localPropagation);
        }
    }

    protected void setPropagationData(SocializeAction action, ShareType shareType) {
        if (shareType != null) {
            Propagation localPropagation = this.newPropagation();
            localPropagation.addThirdParty(shareType);
            String appStore = null;
            if (this.config != null) {
                appStore = this.config.getProperty("redirect.app.store");
            }
            if (!StringUtils.isEmpty(appStore)) {
                String abbrev = this.appUtils.getAppStoreAbbreviation(appStore);
                localPropagation.addExtraParam("f", abbrev);
            }
            action.setPropagationInfoRequest(localPropagation);
        }
    }

    protected Propagation newPropagation() {
        return new Propagation();
    }

    public ListResult<T> list(SocializeSession session, String endpoint, String key, String ... ids) throws SocializeException {
        return this.provider.list(session, endpoint, key, ids, 0, 100);
    }

    public ListResult<T> list(SocializeSession session, String endpoint, String key, String idKey, Map<String, String> extraParams, int startIndex, int endIndex, String ... ids) throws SocializeException {
        return this.provider.list(session, endpoint, key, ids, idKey, extraParams, startIndex, endIndex);
    }

    public ListResult<T> list(SocializeSession session, String endpoint, String key, int startIndex, int endIndex, String ... ids) throws SocializeException {
        return this.provider.list(session, endpoint, key, ids, startIndex, endIndex);
    }

    public ListResult<T> list(SocializeSession session, String endpoint) throws SocializeException {
        return this.provider.list(session, endpoint, 0, 100);
    }

    public ListResult<T> list(SocializeSession session, String endpoint, int startIndex, int endIndex) throws SocializeException {
        return this.provider.list(session, endpoint, startIndex, endIndex);
    }

    public T get(SocializeSession session, String endpoint, String id) throws SocializeException {
        return (T)((SocializeObject)this.provider.get(session, endpoint, id));
    }

    public T get(SocializeSession session, String endpoint, String id, ActionType type) throws SocializeException {
        return (T)((SocializeObject)this.provider.get(session, endpoint, id, type));
    }

    public void delete(SocializeSession session, String endpoint, String id) throws SocializeException {
        this.provider.delete(session, endpoint, id);
    }

    public ListResult<T> put(SocializeSession session, String endpoint, T object) throws SocializeException {
        return this.provider.put(session, endpoint, object);
    }

    public ListResult<T> put(SocializeSession session, String endpoint, List<T> objects) throws SocializeException {
        return this.provider.put(session, endpoint, objects);
    }

    public ListResult<T> post(SocializeSession session, String endpoint, T object, boolean isJSONResponse) throws SocializeException {
        return this.provider.post(session, endpoint, object, isJSONResponse);
    }

    public ListResult<T> post(SocializeSession session, String endpoint, List<T> objects) throws SocializeException {
        return this.post(session, endpoint, objects, true);
    }

    public ListResult<T> post(SocializeSession session, String endpoint, List<T> objects, boolean isJSONResponse) throws SocializeException {
        return this.provider.post(session, endpoint, objects, isJSONResponse);
    }

    public T putAsPost(SocializeSession session, String endpoint, T object) throws SocializeException {
        return (T)((SocializeObject)this.provider.putAsPost(session, endpoint, object));
    }

    public void listAsync(SocializeSession session, String endpoint, String key, int startIndex, int endIndex, SocializeActionListener listener, String ... ids) {
        this.listAsync(session, endpoint, key, "id", null, startIndex, endIndex, listener, ids);
    }

    public void listAsync(SocializeSession session, String endpoint, String key, String idKey, Map<String, String> extraParams, int startIndex, int endIndex, SocializeActionListener listener, String ... ids) {
        AsyncGetter getter = new AsyncGetter(session, listener);
        SocializeGetRequest request = new SocializeGetRequest();
        request.setEndpoint(endpoint);
        request.setRequestType(RequestType.LIST);
        request.setExtraParams(extraParams);
        request.setKey(key);
        request.setIds(ids);
        request.setIdKey(idKey);
        request.setStartIndex(startIndex);
        request.setEndIndex(endIndex);
        getter.execute(new SocializeGetRequest[]{request});
    }

    public void listAsync(SocializeSession session, String endpoint, String key, SocializeActionListener listener, String ... ids) {
        this.listAsync(session, endpoint, key, 0, 100, listener, ids);
    }

    public void listAsync(SocializeSession session, String endpoint, int startIndex, int endIndex, SocializeActionListener listener) {
        AsyncGetter getter = new AsyncGetter(session, listener);
        SocializeGetRequest request = new SocializeGetRequest();
        request.setRequestType(RequestType.LIST_WITHOUT_ENTITY);
        request.setEndpoint(endpoint);
        request.setStartIndex(startIndex);
        request.setEndIndex(endIndex);
        getter.execute(new SocializeGetRequest[]{request});
    }

    public void listAsync(SocializeSession session, String endpoint, SocializeActionListener listener) {
        this.listAsync(session, endpoint, 0, 100, listener);
    }

    public void getByEntityAsync(SocializeSession session, String endpoint, String key, SocializeActionListener listener) {
        AsyncGetter getter = new AsyncGetter(session, listener);
        SocializeGetRequest request = new SocializeGetRequest();
        request.setRequestType(RequestType.LIST);
        request.setEndpoint(endpoint);
        request.setKey(key);
        getter.execute(new SocializeGetRequest[]{request});
    }

    public void getAsync(SocializeSession session, String endpoint, String id, SocializeActionListener listener) {
        AsyncGetter getter = new AsyncGetter(session, listener);
        SocializeGetRequest request = new SocializeGetRequest();
        request.setRequestType(RequestType.GET);
        request.setEndpoint(endpoint);
        request.setIds(id);
        getter.execute(new SocializeGetRequest[]{request});
    }

    public void deleteAsync(SocializeSession session, String endpoint, String id, SocializeActionListener listener) {
        AsyncGetter getter = new AsyncGetter(session, listener);
        SocializeGetRequest request = new SocializeGetRequest();
        request.setRequestType(RequestType.DELETE);
        request.setEndpoint(endpoint);
        request.setIds(id);
        getter.execute(new SocializeGetRequest[]{request});
    }

    public void putAsync(SocializeSession session, String endpoint, T object, SocializeActionListener listener) {
        AsyncPutter poster = new AsyncPutter(session, listener);
        SocializePutRequest<T> request = new SocializePutRequest<T>();
        request.setRequestType(RequestType.PUT);
        request.setEndpoint(endpoint);
        request.setObject(object);
        poster.execute(new SocializePutRequest[]{request});
    }

    public void putAsync(SocializeSession session, String endpoint, List<T> objects, SocializeActionListener listener) {
        AsyncPutter poster = new AsyncPutter(session, listener);
        SocializePutRequest<T> request = new SocializePutRequest<T>();
        request.setRequestType(RequestType.PUT);
        request.setEndpoint(endpoint);
        request.setObjects(objects);
        poster.execute(new SocializePutRequest[]{request});
    }

    public void postAsync(SocializeSession session, String endpoint, T object, SocializeActionListener listener) {
        this.postAsync(session, endpoint, object, true, listener);
    }

    public void postAsync(SocializeSession session, String endpoint, T object, boolean jsonResponse, SocializeActionListener listener) {
        AsyncPutter poster = new AsyncPutter(session, listener);
        SocializePutRequest<T> request = new SocializePutRequest<T>();
        request.setRequestType(RequestType.POST);
        request.setEndpoint(endpoint);
        request.setObject(object);
        request.setJsonResponse(jsonResponse);
        poster.execute(new SocializePutRequest[]{request});
    }

    public void postAsync(SocializeSession session, String endpoint, List<T> objects, SocializeActionListener listener) {
        this.postAsync(session, endpoint, objects, true, listener);
    }

    public void postAsync(SocializeSession session, String endpoint, List<T> objects, boolean jsonResponse, SocializeActionListener listener) {
        AsyncPutter poster = new AsyncPutter(session, listener);
        SocializePutRequest<T> request = new SocializePutRequest<T>();
        request.setRequestType(RequestType.POST);
        request.setEndpoint(endpoint);
        request.setObjects(objects);
        request.setJsonResponse(jsonResponse);
        poster.execute(new SocializePutRequest[]{request});
    }

    public void putAsPostAsync(SocializeSession session, String endpoint, T object, SocializeActionListener listener) {
        AsyncPutter poster = new AsyncPutter(session, listener);
        SocializePutRequest<T> request = new SocializePutRequest<T>();
        request.setRequestType(RequestType.PUT_AS_POST);
        request.setEndpoint(endpoint);
        request.setObject(object);
        poster.execute(new SocializePutRequest[]{request});
    }

    public void authenticateAsync(Context context, String key, String secret, String uuid, String androidId, AuthProviderData data, final SocializeAuthListener listener, final SocializeSessionConsumer sessionConsumer, boolean do3rdPartyAuth) {
        SocializeActionListener wrapper = null;
        final SocializeAuthListener localListener = new SocializeAuthListener(){

            @Override
            public void onError(SocializeException error) {
                if (listener != null) {
                    listener.onError(error);
                } else if (SocializeApi.this.logger != null) {
                    SocializeApi.this.logger.error("Failure during auth", (Throwable)error);
                }
            }

            @Override
            public void onCancel() {
                if (listener != null) {
                    listener.onCancel();
                }
            }

            @Override
            public void onAuthSuccess(SocializeSession session) {
                if (sessionConsumer != null) {
                    sessionConsumer.setSession(session);
                }
                if (listener != null) {
                    listener.onAuthSuccess(session);
                }
            }

            @Override
            public void onAuthFail(SocializeException error) {
                if (listener != null) {
                    listener.onAuthFail(error);
                } else if (SocializeApi.this.logger != null) {
                    SocializeApi.this.logger.error("Failure during auth", (Throwable)error);
                }
            }
        };
        wrapper = new SocializeActionListener(){

            @Override
            public void onResult(RequestType type, SocializeResponse response) {
                SocializeAuthResponse authResponse = (SocializeAuthResponse)response;
                localListener.onAuthSuccess(authResponse.getSession());
            }

            @Override
            public void onError(SocializeException error) {
                if (SocializeApi.this.httpUtils != null && SocializeApi.this.httpUtils.isAuthError(error)) {
                    localListener.onAuthFail(error);
                } else {
                    localListener.onError(error);
                }
            }
        };
        SocializeAuthRequest request = new SocializeAuthRequest();
        request.setEndpoint("/authenticate/");
        request.setConsumerKey(key);
        request.setConsumerSecret(secret);
        request.setUdid(uuid);
        request.setAdvertiserId(androidId);
        request.setAuthProviderData(data);
        AuthProviderType authProviderType = this.getAuthProviderType(data);
        if (do3rdPartyAuth && !authProviderType.equals((Object)AuthProviderType.SOCIALIZE)) {
            this.handle3rdPartyAuth(context, request, wrapper, localListener, key, secret);
        } else {
            this.handleRegularAuth(context, request, wrapper, localListener, key, secret);
        }
    }

    protected AuthProviderType getAuthProviderType(AuthProviderData data) {
        if (data == null) {
            return AuthProviderType.SOCIALIZE;
        }
        AuthProviderType authProviderType = null;
        AuthProviderInfo authProviderInfo = data.getAuthProviderInfo();
        if (authProviderInfo != null) {
            authProviderType = authProviderInfo.getType();
        }
        return authProviderType;
    }

    protected void validate(AuthProviderData data) throws SocializeException {
        AuthProviderInfo authProviderInfo = data.getAuthProviderInfo();
        if (authProviderInfo == null) {
            throw new SocializeException("Empty auth provider info");
        }
        authProviderInfo.validate();
    }

    protected void handleRegularAuth(Context context, SocializeAuthRequest request, SocializeActionListener wrapper, SocializeAuthListener listener, String key, String secret) {
        AsyncAuthenicator authenicator = new AsyncAuthenicator(context, null, wrapper);
        authenicator.execute(new SocializeAuthRequest[]{request});
    }

    protected void handle3rdPartyAuth(final Context context, final SocializeAuthRequest request, final SocializeActionListener wrapper, final SocializeAuthListener listener, final String key, final String secret) {
        AuthProviderType authProviderType;
        SocializeSession session;
        AuthProviderData authProviderData;
        block13: {
            authProviderData = request.getAuthProviderData();
            session = null;
            authProviderType = this.getAuthProviderType(authProviderData);
            try {
                this.validate(authProviderData);
            }
            catch (SocializeException error) {
                if (listener != null) {
                    listener.onError(error);
                }
                if (this.logger == null) break block13;
                this.logger.error("Error validating auth provider data", (Throwable)error);
            }
        }
        try {
            session = this.loadSession(request.getEndpoint(), key, secret);
        }
        catch (SocializeException e) {
            this.logger.warn("Failed to load saved session data", (Throwable)e);
        }
        if (session == null || !this.provider.validateSession(session, authProviderData)) {
            AuthProvider<AuthProviderInfo> authProvider = this.authProviders.getProvider(authProviderType);
            if (authProvider != null) {
                AuthProviderListener authProviderListener = new AuthProviderListener(){

                    @Override
                    public void onError(SocializeException error) {
                        if (listener != null) {
                            listener.onError(error);
                        }
                    }

                    @Override
                    public void onAuthSuccess(AuthProviderResponse response) {
                        authProviderData.setUserId3rdParty(response.getUserId());
                        authProviderData.setToken3rdParty(response.getToken());
                        authProviderData.setSecret3rdParty(response.getSecret());
                        SocializeApi.this.handleRegularAuth(context, request, wrapper, listener, key, secret);
                    }

                    @Override
                    public void onAuthFail(SocializeException error) {
                        if (listener != null) {
                            listener.onAuthFail(error);
                        }
                    }

                    @Override
                    public void onCancel() {
                        if (listener != null) {
                            listener.onCancel();
                        }
                    }
                };
                AuthProviderInfo authProviderInfo = authProviderData.getAuthProviderInfo();
                if (authProviderInfo != null) {
                    authProvider.authenticate(context, authProviderInfo, authProviderListener);
                } else {
                    if (listener != null) {
                        listener.onError(new SocializeException("Authentication failed.  No AuthProviderInfo found"));
                    }
                    this.logger.error("No AuthProviderInfo found during auth");
                }
            } else {
                this.logger.error("No provider found for auth type [" + authProviderType.getName() + "]");
            }
        } else if (listener != null) {
            listener.onAuthSuccess(session);
        }
    }

    public void setResponseFactory(SocializeResponseFactory<T> responseFactory) {
        this.responseFactory = responseFactory;
    }

    public void setAppUtils(AppUtils appUtils) {
        this.appUtils = appUtils;
    }

    public void setConfig(SocializeConfig config) {
        this.config = config;
    }

    public void setNotificationChecker(NotificationChecker notificationChecker) {
        this.notificationChecker = notificationChecker;
    }

    public void setAuthProviders(AuthProviders authProviders) {
        this.authProviders = authProviders;
    }

    public void setLogger(SocializeLogger logger) {
        this.logger = logger;
    }

    public void setHttpUtils(HttpUtils httpUtils) {
        this.httpUtils = httpUtils;
    }

    public void setLocationProvider(SocializeLocationProvider locationProvider) {
        this.locationProvider = locationProvider;
    }

    protected void setLocation(SocializeAction action) {
        UserSettings settings;
        SocializeSession session;
        Location location = null;
        if (this.locationProvider != null) {
            location = this.locationProvider.getLastKnownLocation();
        }
        if (location != null) {
            action.setLon(location.getLongitude());
            action.setLat(location.getLatitude());
        }
        if ((session = Socialize.getSocialize().getSession()) != null && (settings = session.getUserSettings()) != null) {
            action.setLocationShared(settings.isLocationEnabled());
        }
    }

    public static final <T extends SocializeObject> void handleResults(SocializeEntityResponse<T> result, SocializeLogger logger) throws SocializeException {
        ListResult<T> results = result.getResults();
        if (results != null) {
            List<T> items = results.getItems();
            List<ActionError> errors = results.getErrors();
            if ((items == null || items.size() == 0) && result.isResultsExpected()) {
                if (errors != null && errors.size() > 0) {
                    throw new SocializeException(errors.get(0).getMessage());
                }
                throw new SocializeException("No results found in response");
            }
            if (errors != null && errors.size() > 0) {
                for (ActionError actionError : errors) {
                    if (logger == null || StringUtils.isEmpty(actionError.getMessage())) continue;
                    logger.warn(actionError.getMessage());
                }
            }
        } else if (result.isResultsExpected()) {
            throw new SocializeException("No results found in response");
        }
    }

    class AsyncGetter
    extends AbstractAsyncProcess<SocializeGetRequest, Void, SocializeEntityResponse<T>> {
        public AsyncGetter(SocializeSession session, SocializeActionListener listener) {
            super(session, listener);
        }

        @Override
        protected SocializeEntityResponse<T> doInBackground(SocializeGetRequest request) throws SocializeException {
            SocializeEntityResponse response = null;
            response = SocializeApi.this.responseFactory != null ? SocializeApi.this.responseFactory.newEntityResponse() : new SocializeEntityResponse();
            ListResult results = null;
            switch (this.requestType) {
                case GET: {
                    Object result = SocializeApi.this.get(this.session, request.getEndpoint(), request.getIds()[0]);
                    response.addResult(result);
                    break;
                }
                case LIST: {
                    results = SocializeApi.this.list(this.session, request.getEndpoint(), request.getKey(), request.getIdKey(), request.getExtraParams(), request.getStartIndex(), request.getEndIndex(), request.getIds());
                    response.setResults(results);
                    break;
                }
                case LIST_AS_GET: {
                    results = SocializeApi.this.list(this.session, request.getEndpoint(), request.getKey(), request.getIdKey(), request.getExtraParams(), request.getStartIndex(), request.getEndIndex(), request.getIds());
                    response.setResults(results);
                    break;
                }
                case LIST_WITHOUT_ENTITY: {
                    results = SocializeApi.this.list(this.session, request.getEndpoint(), request.getStartIndex(), request.getEndIndex());
                    response.setResults(results);
                    break;
                }
                case DELETE: {
                    SocializeApi.this.delete(this.session, request.getEndpoint(), request.getIds()[0]);
                }
            }
            return response;
        }
    }

    class AsyncPutter
    extends AbstractAsyncProcess<SocializePutRequest<T>, Void, SocializeEntityResponse<T>> {
        public AsyncPutter(SocializeSession session, SocializeActionListener listener) {
            super(session, listener);
        }

        @Override
        protected SocializeEntityResponse<T> doInBackground(SocializePutRequest<T> request) throws SocializeException {
            SocializeEntityResponse response = null;
            response = SocializeApi.this.responseFactory != null ? SocializeApi.this.responseFactory.newEntityResponse() : new SocializeEntityResponse();
            response.setResultsExpected(request.isJsonResponse());
            ListResult<Object> results = null;
            switch (this.requestType) {
                case POST: {
                    if (request.getObjects() != null) {
                        results = SocializeApi.this.post(this.session, request.getEndpoint(), request.getObjects(), request.isJsonResponse());
                    } else if (request.getObject() != null) {
                        results = SocializeApi.this.post(this.session, request.getEndpoint(), (SocializeObject)request.getObject(), request.isJsonResponse());
                    }
                    response.setResults(results);
                    break;
                }
                case PUT: {
                    if (request.getObjects() != null) {
                        results = SocializeApi.this.put(this.session, request.getEndpoint(), request.getObjects());
                    } else if (request.getObject() != null) {
                        results = SocializeApi.this.put(this.session, request.getEndpoint(), (SocializeObject)request.getObject());
                    }
                    response.setResults(results);
                    break;
                }
                case PUT_AS_POST: {
                    if (request.getObject() == null) break;
                    SocializeObject result = SocializeApi.this.putAsPost(this.session, request.getEndpoint(), (SocializeObject)request.getObject());
                    response.addResult(result);
                }
            }
            return response;
        }

        @Override
        protected void onPostExecuteManaged(SocializeEntityResponse<T> result) {
            if (this.listener != null) {
                if (this.error != null) {
                    this.listener.onError(SocializeException.wrap(this.error));
                } else {
                    try {
                        SocializeApi.handleResults(result, SocializeApi.this.logger);
                        this.listener.onResult(this.requestType, result);
                    }
                    catch (SocializeException e) {
                        this.listener.onError(e);
                    }
                }
            }
        }
    }

    class AsyncAuthenicator
    extends AbstractAsyncProcess<SocializeAuthRequest, Void, SocializeAuthResponse> {
        public AsyncAuthenicator(Context context, SocializeSession session, SocializeActionListener listener) {
            super(context, session, listener);
        }

        @Override
        protected SocializeAuthResponse doInBackground(SocializeAuthRequest request) throws SocializeException {
            SocializeAuthResponse response = null;
            response = SocializeApi.this.responseFactory != null ? SocializeApi.this.responseFactory.newAuthResponse() : new SocializeAuthResponse();
            AuthProviderData authProviderData = request.getAuthProviderData();
            AuthProviderType authProviderType = SocializeApi.this.getAuthProviderType(authProviderData);
            SocializeSession session = authProviderType == null || authProviderType.equals((Object)AuthProviderType.SOCIALIZE) ? SocializeApi.this.authenticate(this.context, request.getEndpoint(), request.getConsumerKey(), request.getConsumerSecret(), request.getUdid(), request.getAdvertiserId()) : SocializeApi.this.authenticate(this.context, request.getEndpoint(), request.getConsumerKey(), request.getConsumerSecret(), authProviderData, request.getUdid(), request.getAdvertiserId());
            response.setSession(session);
            return response;
        }
    }

    abstract class AbstractAsyncProcess<Params extends SocializeRequest, Progress, Result extends SocializeResponse>
    extends ManagedAsyncTask<Params, Progress, Result> {
        RequestType requestType;
        SocializeSession session;
        Exception error = null;
        SocializeActionListener listener = null;
        Context context;

        public AbstractAsyncProcess(Context context, SocializeSession session, SocializeActionListener listener) {
            this(session, listener);
            this.context = context;
        }

        public AbstractAsyncProcess(SocializeSession session, SocializeActionListener listener) {
            this.session = session;
            this.listener = listener;
        }

        protected final Result doInBackground(Params ... params) {
            Params request = params[0];
            this.requestType = ((SocializeRequest)request).getRequestType();
            Result result = null;
            try {
                result = this.doInBackground(request);
            }
            catch (Exception error) {
                this.error = error;
            }
            return result;
        }

        @Override
        protected void onPostExecuteManaged(Result result) {
            if (this.listener != null) {
                if (this.error != null) {
                    this.listener.onError(SocializeException.wrap(this.error));
                } else {
                    this.listener.onResult(this.requestType, (SocializeResponse)result);
                }
            }
        }

        protected abstract Result doInBackground(Params var1) throws SocializeException;
    }

    public static enum RequestType {
        AUTH,
        PUT,
        POST,
        PUT_AS_POST,
        GET,
        LIST,
        LIST_AS_GET,
        LIST_WITHOUT_ENTITY,
        DELETE;

    }
}

