/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.api;

import com.socialize.api.SocializeSessionFactory;
import com.socialize.api.SocializeSessionImpl;
import com.socialize.api.WritableSession;
import com.socialize.auth.AuthProviderData;
import com.socialize.auth.AuthProviderInfo;
import com.socialize.auth.DefaultUserProviderCredentials;
import com.socialize.auth.UserProviderCredentials;
import com.socialize.auth.UserProviderCredentialsMap;
import com.socialize.config.SocializeConfig;
import com.socialize.ui.profile.UserSettings;

public class DefaultSocializeSessionFactory
implements SocializeSessionFactory {
    private SocializeConfig config;

    public DefaultSocializeSessionFactory(SocializeConfig config) {
        this.config = config;
    }

    @Override
    public WritableSession create(String key, String secret, AuthProviderData data) {
        DefaultUserProviderCredentials userProviderCredentials = new DefaultUserProviderCredentials();
        userProviderCredentials.setAccessToken(data.getToken3rdParty());
        userProviderCredentials.setTokenSecret(data.getSecret3rdParty());
        userProviderCredentials.setUserId(data.getUserId3rdParty());
        userProviderCredentials.setAuthProviderInfo(data.getAuthProviderInfo());
        return this.create(key, secret, userProviderCredentials);
    }

    @Override
    public WritableSession create(String key, String secret, UserProviderCredentials userProviderCredentials) {
        String host;
        SocializeSessionImpl session = SocializeSessionImpl.getInstance();
        session.setConsumerKey(key);
        session.setConsumerSecret(secret);
        session.setUserSettings(new UserSettings());
        AuthProviderInfo authProviderInfo = userProviderCredentials.getAuthProviderInfo();
        if (authProviderInfo != null) {
            session.setUserProviderCredentials(authProviderInfo.getType(), userProviderCredentials);
        }
        if (this.config != null && (host = this.config.getProperty("api.host")) != null) {
            session.setHost(host.trim());
        }
        return session;
    }

    @Override
    public WritableSession create(String key, String secret, UserProviderCredentialsMap userProviderCredentialsMap) {
        String host;
        SocializeSessionImpl session = SocializeSessionImpl.getInstance();
        session.setConsumerKey(key);
        session.setConsumerSecret(secret);
        session.setUserProviderCredentials(userProviderCredentialsMap);
        if (this.config != null && (host = this.config.getProperty("api.host")) != null) {
            session.setHost(host.trim());
        }
        return session;
    }
}

