/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.api;

import com.socialize.Socialize;
import com.socialize.SocializeService;
import com.socialize.api.ShareMessageBuilder;
import com.socialize.api.SocializeSession;
import com.socialize.entity.Entity;
import com.socialize.entity.PropagationInfo;
import com.socialize.entity.User;
import com.socialize.i18n.LocalizationService;
import com.socialize.util.AppUtils;
import com.socialize.util.StringUtils;

public class DefaultShareMessageBuilder
implements ShareMessageBuilder {
    private AppUtils appUtils;
    private LocalizationService localizationService;

    @Override
    public String buildShareSubject(Entity entity) {
        String entityKey = entity.getKey();
        String entityName = entity.getName();
        StringBuilder builder = new StringBuilder();
        SocializeSession session = this.getSocialize().getSession();
        User currentUser = null;
        if (session != null) {
            currentUser = session.getUser();
        }
        String sharingText = this.localizationService.getString("socialize_share_text_sharing");
        String sharedText = this.localizationService.getString("socialize_share_text_shared");
        if (currentUser != null) {
            String name = currentUser.getDisplayName();
            if (StringUtils.isEmpty(name)) {
                builder.append(sharingText);
                builder.append(" ");
            } else {
                builder.append(name);
                builder.append(" ");
                builder.append(sharedText);
                builder.append(" ");
            }
        } else {
            builder.append(sharingText);
            builder.append(" ");
        }
        if (!StringUtils.isEmpty(entityName)) {
            builder.append(entityName);
        } else {
            builder.append(entityKey);
        }
        return builder.toString();
    }

    protected SocializeService getSocialize() {
        return Socialize.getSocialize();
    }

    @Override
    public String getEntityLink(Entity entity, PropagationInfo urlSet, boolean html) {
        String entityName = entity.getName();
        StringBuilder builder = new StringBuilder();
        if (html) {
            builder.append("<a href=\"");
            builder.append(urlSet.getEntityUrl());
            builder.append("\">");
        }
        if (!StringUtils.isEmpty(entityName)) {
            builder.append(entityName);
        }
        if (html) {
            builder.append("</a>");
        } else {
            builder.append(": ");
            builder.append(urlSet.getEntityUrl());
        }
        return builder.toString();
    }

    @Override
    public String buildShareMessage(Entity entity, PropagationInfo urlSet, String comment, boolean html, boolean includeAppLink) {
        StringBuilder builder = new StringBuilder();
        if (!StringUtils.isEmpty(comment)) {
            builder.append(comment);
            builder.append(this.getNewLine(html));
            builder.append(this.getNewLine(html));
        } else {
            builder.append(this.getNewLine(html));
            builder.append(this.getNewLine(html));
        }
        builder.append(this.getEntityLink(entity, urlSet, html));
        String sentFromText = this.localizationService.getString("socialize_share_text_sent_from");
        if (includeAppLink) {
            builder.append(this.getNewLine(html));
            builder.append(this.getNewLine(html));
            builder.append(sentFromText);
            builder.append(" ");
            if (html) {
                builder.append("<a href=\"");
                builder.append(urlSet.getAppUrl());
                builder.append("\">");
                builder.append(this.appUtils.getAppName());
                builder.append("</a>");
            } else {
                builder.append(this.appUtils.getAppName());
                builder.append(" ");
                builder.append(urlSet.getAppUrl());
            }
        }
        return builder.toString();
    }

    public void setAppUtils(AppUtils appUtils) {
        this.appUtils = appUtils;
    }

    protected String getNewLine(boolean html) {
        if (html) {
            return "<br/>";
        }
        return "\n";
    }

    public void setLocalizationService(LocalizationService localizationService) {
        this.localizationService = localizationService;
    }
}

