/*
 * Decompiled with CFR 0.152.
 */
package com.socialize;

import android.app.Activity;
import android.content.Context;
import com.socialize.SocializeActionProxy;
import com.socialize.api.action.user.UserUtilsProxy;
import com.socialize.entity.SocializeAction;
import com.socialize.entity.User;
import com.socialize.error.SocializeException;
import com.socialize.listener.user.UserGetListener;
import com.socialize.listener.user.UserSaveListener;
import com.socialize.log.SocializeLogger;
import com.socialize.networks.SocialNetwork;
import com.socialize.ui.action.OnActionDetailViewListener;
import com.socialize.ui.profile.UserSettings;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;

public class UserUtils {
    static UserUtilsProxy proxy = (UserUtilsProxy)Proxy.newProxyInstance(UserUtilsProxy.class.getClassLoader(), new Class[]{UserUtilsProxy.class}, (InvocationHandler)new SocializeActionProxy("userUtils"));

    public static SocialNetwork[] getAutoPostSocialNetworks(Context context) throws SocializeException {
        return proxy.getAutoPostSocialNetworks(context);
    }

    public static User getCurrentUser(Context context) throws SocializeException {
        return proxy.getCurrentUser(context);
    }

    public static void getCurrentUserAsync(Context context, UserGetListener listener) {
        proxy.getCurrentUserAsync(context, listener);
    }

    public static void saveUserAsync(Context context, User user, UserSaveListener listener) {
        proxy.saveUserAsync(context, user, listener);
    }

    public static UserSettings getUserSettings(Context context) throws SocializeException {
        return proxy.getUserSettings(context);
    }

    public static void getUser(Context context, long id, UserGetListener listener) {
        proxy.getUser(context, id, listener);
    }

    public static void showUserProfile(Activity context, User user) {
        proxy.showUserProfileView(context, user, null, null);
    }

    public static void showUserProfileWithAction(Activity context, User user, SocializeAction action) {
        proxy.showUserProfileView(context, user, action, null);
    }

    public static void showUserProfile(Activity context, User user, OnActionDetailViewListener onActionDetailViewListener) {
        proxy.showUserProfileView(context, user, null, onActionDetailViewListener);
    }

    public static void showUserProfileWithAction(Activity context, User user, SocializeAction action, OnActionDetailViewListener onActionDetailViewListener) {
        proxy.showUserProfileView(context, user, action, onActionDetailViewListener);
    }

    public static void showUserSettings(Activity context) {
        try {
            proxy.showUserSettingsView(context, UserUtils.getCurrentUser((Context)context).getId());
        }
        catch (SocializeException e) {
            SocializeLogger.e("Error displaying user settings", e);
        }
    }

    public static void showUserSettingsForResult(Activity context, int requestCode) {
        try {
            proxy.showUserSettingsViewForResult(context, UserUtils.getCurrentUser((Context)context).getId(), requestCode);
        }
        catch (SocializeException e) {
            SocializeLogger.e("Error displaying user settings", e);
        }
    }

    public static void saveUserSettings(Context context, UserSettings userSettings, UserSaveListener listener) {
        proxy.saveUserSettings(context, userSettings, listener);
    }

    public static void clearLocalSessionData(Context context) {
        proxy.clearSession(context);
    }
}

