/*
 * Decompiled with CFR 0.152.
 */
package com.socialize;

import android.content.Context;
import com.socialize.listener.SocializeInitListener;
import com.socialize.util.StringUtils;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;

public class SocializeSystem {
    private String[] beanOverrides;
    private SocializeInitListener initListener;
    private boolean configChanged = false;
    private String[] config = null;
    private Properties beanOverrideProps = null;
    static final SocializeSystem instance = new SocializeSystem();
    static final String[] CORE_CONFIG = new String[]{"socialize_core_beans.xml", "socialize_ui_beans.xml"};

    public static SocializeSystem getInstance() {
        return instance;
    }

    public String[] getBeanConfig(final Context context) {
        if (this.config == null || this.configChanged) {
            String[] arrOverrides;
            String overrides;
            if (this.beanOverrideProps == null) {
                final CountDownLatch latch = new CountDownLatch(1);
                new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        SocializeSystem.this.beanOverrideProps = new Properties();
                        try {
                            SocializeSystem.this.beanOverrideProps.load(context.getAssets().open("socialize.properties"));
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        finally {
                            latch.countDown();
                        }
                    }
                }.start();
                try {
                    latch.await();
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
            }
            if (this.beanOverrideProps != null && !StringUtils.isEmpty(overrides = this.beanOverrideProps.getProperty("bean.overrides")) && !StringUtils.isEmpty(arrOverrides = overrides.split("\\s*,\\s*"))) {
                if (StringUtils.isEmpty(this.beanOverrides)) {
                    this.beanOverrides = arrOverrides;
                } else {
                    String[] newOverrides = new String[this.beanOverrides.length + arrOverrides.length];
                    System.arraycopy(this.beanOverrides, 0, newOverrides, 0, this.beanOverrides.length);
                    System.arraycopy(arrOverrides, 0, newOverrides, this.beanOverrides.length, arrOverrides.length);
                    this.beanOverrides = newOverrides;
                }
            }
            if (!StringUtils.isEmpty(this.beanOverrides)) {
                this.config = new String[this.beanOverrides.length + CORE_CONFIG.length];
                System.arraycopy(CORE_CONFIG, 0, this.config, 0, CORE_CONFIG.length);
                System.arraycopy(this.beanOverrides, 0, this.config, CORE_CONFIG.length, this.beanOverrides.length);
            } else {
                this.config = CORE_CONFIG;
            }
        }
        return this.config;
    }

    public void destroy() {
        this.initListener = null;
        this.beanOverrides = null;
    }

    public SocializeInitListener getSystemInitListener() {
        return this.initListener;
    }

    void setSystemInitListener(SocializeInitListener initListener) {
        this.initListener = initListener;
    }

    void setBeanOverrides(String ... beanOverrides) {
        this.beanOverrides = beanOverrides;
        this.configChanged = true;
    }
}

