/*
 * Decompiled with CFR 0.152.
 */
package com.socialize;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.socialize.ConfigUtils;
import com.socialize.Socialize;
import com.socialize.SocializeService;
import com.socialize.SocializeSystem;
import com.socialize.android.ioc.IOCContainer;
import com.socialize.android.ioc.Logger;
import com.socialize.api.SocializeSession;
import com.socialize.api.action.ShareType;
import com.socialize.api.action.share.ShareSystem;
import com.socialize.api.action.user.UserSystem;
import com.socialize.auth.AuthProvider;
import com.socialize.auth.AuthProviderInfo;
import com.socialize.auth.AuthProviderInfoBuilder;
import com.socialize.auth.AuthProviderType;
import com.socialize.auth.AuthProviders;
import com.socialize.auth.SocializeAuthProviderInfo;
import com.socialize.auth.UserProviderCredentials;
import com.socialize.auth.UserProviderCredentialsMap;
import com.socialize.concurrent.AsyncTaskManager;
import com.socialize.concurrent.ManagedAsyncTask;
import com.socialize.config.SocializeConfig;
import com.socialize.entity.Comment;
import com.socialize.error.SocializeException;
import com.socialize.init.SocializeInitializationAsserter;
import com.socialize.ioc.SocializeIOC;
import com.socialize.listener.SocializeAuthListener;
import com.socialize.listener.SocializeInitListener;
import com.socialize.listener.SocializeListener;
import com.socialize.location.SocializeLocationProvider;
import com.socialize.log.SocializeLogger;
import com.socialize.loopy.LoopyService;
import com.socialize.networks.facebook.FacebookFacade;
import com.socialize.networks.facebook.FacebookUtils;
import com.socialize.networks.twitter.TwitterUtils;
import com.socialize.notifications.NotificationChecker;
import com.socialize.notifications.SocializeC2DMReceiver;
import com.socialize.notifications.WakeLock;
import com.socialize.ui.ActivityIOCProvider;
import com.socialize.ui.SocializeEntityLoader;
import com.socialize.util.AppUtils;
import com.socialize.util.ClassLoaderProvider;
import com.socialize.util.DisplayUtils;
import com.socialize.util.EntityLoaderUtils;
import com.socialize.util.ResourceLocator;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class SocializeServiceImpl
implements SocializeService {
    static final String receiver = SocializeC2DMReceiver.class.getName();
    static final Lock initLock = new ReentrantReadWriteLock().writeLock();
    private SocializeLogger logger;
    private IOCContainer container;
    private SocializeSession session;
    private AuthProviderInfoBuilder authProviderInfoBuilder;
    private SocializeInitializationAsserter asserter;
    private ShareSystem shareSystem;
    private UserSystem userSystem;
    private LoopyService loopyService;
    private AuthProviders authProviders;
    private NotificationChecker notificationChecker;
    private AppUtils appUtils;
    private SocializeLocationProvider locationProvider;
    private SocializeSystem system = SocializeSystem.getInstance();
    private SocializeConfig config = new SocializeConfig();
    private SocializeEntityLoader entityLoader;
    private Class<?> userSettingsActivity;
    private String[] initPaths = null;
    private int initCount = 0;
    private boolean paused = false;

    public SocializeServiceImpl() {
        this.logger = this.newLogger();
    }

    @Override
    public Class<?> getUserSettingsActivity() {
        return this.userSettingsActivity;
    }

    @Override
    public void setUserSettingsActivity(Class<?> userSettingsActivity) {
        this.userSettingsActivity = userSettingsActivity;
    }

    @Override
    public boolean handleBroadcastIntent(Context context, Intent intent) {
        String action = intent.getAction();
        if (action != null && ("com.google.android.c2dm.intent.RECEIVE".equals(action) || "com.google.android.c2dm.intent.REGISTRATION".equals(action))) {
            if ("com.google.android.c2dm.intent.RECEIVE".equals(action)) {
                String source;
                Bundle extras = intent.getExtras();
                if (extras != null && (source = extras.getString("source")) != null && source.trim().equalsIgnoreCase("socialize")) {
                    this.handleIntent(context, intent);
                    return true;
                }
            } else {
                this.handleIntent(context, intent);
            }
        }
        return false;
    }

    protected void handleIntent(Context context, Intent intent) {
        this.getWakeLock().acquire(context);
        intent.setClassName(context, receiver);
        context.startService(intent);
    }

    protected WakeLock getWakeLock() {
        return WakeLock.getInstance();
    }

    @Override
    public boolean isSupported(Context context, AuthProviderType type) {
        switch (type) {
            case FACEBOOK: {
                return FacebookUtils.isAvailable(context);
            }
            case TWITTER: {
                return TwitterUtils.isAvailable(context);
            }
        }
        return this.authProviderInfoBuilder.isSupported(type);
    }

    @Override
    public void isSocializeSupported(Context context) throws SocializeException {
        DisplayUtils displayUtils = new DisplayUtils();
        displayUtils.init(context);
        if (displayUtils.isLDPI()) {
            throw new SocializeException("Socialize is not supported on low resolution (LDPI) devices");
        }
    }

    @Override
    public IOCContainer init(Context context) {
        return this.init(context, this.getSystem().getBeanConfig(context));
    }

    @Override
    public IOCContainer init(Context context, String ... paths) {
        try {
            return this.initWithContainer(context, paths);
        }
        catch (Exception e) {
            if (this.logger != null) {
                this.logger.error(0, (Throwable)e);
            } else {
                SocializeLogger.e(e.getMessage(), e);
            }
            return null;
        }
    }

    @Override
    public void initAsync(Context context, SocializeInitListener listener) {
        this.initAsync(context, listener, this.getSystem().getBeanConfig(context));
    }

    @Override
    public void initAsync(Context context, SocializeInitListener listener, String ... paths) {
        new InitTask(this, context, paths, listener, this.logger).execute(new Void[0]);
    }

    public synchronized IOCContainer initWithContainer(Context context, String ... paths) throws Exception {
        return this.initWithContainer(context, this.getSystem().getSystemInitListener(), paths);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized IOCContainer initWithContainer(Context context, SocializeInitListener listener, String ... paths) throws Exception {
        block25: {
            try {
                initLock.lock();
                boolean init = false;
                this.isSocializeSupported(context);
                String[] localPaths = this.getInitPaths();
                if (paths != null) {
                    if (this.isInitialized(context)) {
                        if (localPaths != null) {
                            for (String path : paths) {
                                if (this.binarySearch(localPaths, path) >= 0) continue;
                                if (this.logger != null && this.logger.isInfoEnabled()) {
                                    this.logger.info("New path found for beans [" + path + "].  Re-initializing Socialize");
                                }
                                this.initCount = 0;
                                if (this.container != null) {
                                    if (this.logger != null && this.logger.isDebugEnabled()) {
                                        this.logger.debug("Destroying IOC container");
                                    }
                                    this.container.destroy();
                                }
                                init = true;
                                break;
                            }
                        } else {
                            String msg = "Socialize reported as initialize, but no initPaths were found.  This should not happen!";
                            if (this.logger != null) {
                                this.logger.error(msg);
                            } else {
                                System.err.println(msg);
                            }
                            this.destroy();
                            init = true;
                        }
                    } else {
                        init = true;
                    }
                    if (init) {
                        Logger.LOG_KEY = "Socialize";
                        Logger.logLevel = 5;
                        this.initPaths = paths;
                        if (this.container == null) {
                            this.container = this.newSocializeIOC();
                        }
                        ResourceLocator locator = this.newResourceLocator();
                        locator.setLogger(this.newLogger());
                        ClassLoaderProvider provider = this.newClassLoaderProvider();
                        locator.setClassLoaderProvider(provider);
                        if (this.logger != null) {
                            if (this.logger.isDebugEnabled()) {
                                for (String path : paths) {
                                    this.logger.debug("Initializing Socialize with path [" + path + "]");
                                }
                                Logger.logLevel = 3;
                            } else if (this.logger.isInfoEnabled()) {
                                Logger.logLevel = 4;
                            }
                        }
                        ((SocializeIOC)this.container).init(context, locator, paths);
                        this.init(context, this.container, listener);
                    } else {
                        ++this.initCount;
                    }
                    this.setContext(context);
                    break block25;
                }
                String msg = "Attempt to initialize Socialize with null bean config paths";
                if (this.logger != null) {
                    this.logger.error(msg);
                } else {
                    System.err.println(msg);
                }
            }
            finally {
                initLock.unlock();
            }
        }
        return this.container;
    }

    protected void setContext(Context context) {
        if (this.container != null) {
            this.container.setContext(context);
        }
    }

    protected void onContextDestroyed(Context context) {
        if (this.container != null) {
            this.container.onContextDestroyed(context);
        }
    }

    protected String[] getInitPaths() {
        return this.initPaths;
    }

    protected SocializeIOC newSocializeIOC() {
        return new SocializeIOC();
    }

    protected ResourceLocator newResourceLocator() {
        return new ResourceLocator();
    }

    protected SocializeLogger newLogger() {
        return new SocializeLogger(Socialize.DEFAULT_LOG_LEVEL);
    }

    protected ClassLoaderProvider newClassLoaderProvider() {
        return new ClassLoaderProvider();
    }

    protected int binarySearch(String[] array, String str) {
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].equals(str)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public synchronized void init(Context context, IOCContainer container) {
        this.init(context, container, this.getSystem().getSystemInitListener());
    }

    public synchronized void init(Context context, IOCContainer container, SocializeInitListener listener) {
        block7: {
            if (!this.isInitialized(context)) {
                try {
                    this.container = container;
                    this.container.setContext(context);
                    this.logger = (SocializeLogger)container.getBean("logger");
                    this.loopyService = (LoopyService)container.getBean("loopyService");
                    this.shareSystem = (ShareSystem)container.getBean("shareSystem");
                    this.userSystem = (UserSystem)container.getBean("userSystem");
                    this.asserter = (SocializeInitializationAsserter)container.getBean("initializationAsserter");
                    if (this.authProviders == null) {
                        this.authProviders = (AuthProviders)container.getBean("authProviders");
                    }
                    this.authProviderInfoBuilder = (AuthProviderInfoBuilder)container.getBean("authProviderInfoBuilder");
                    this.notificationChecker = (NotificationChecker)container.getBean("notificationChecker");
                    this.appUtils = (AppUtils)container.getBean("appUtils");
                    this.locationProvider = (SocializeLocationProvider)container.getBean("locationProvider");
                    SocializeConfig mainConfig = (SocializeConfig)container.getBean("config");
                    mainConfig.merge(this.config);
                    mainConfig.merge(ConfigUtils.preInitConfig);
                    this.config = mainConfig;
                    this.initCount = 1;
                    this.verify3rdPartyAuthConfigured();
                    this.initEntityLoader();
                    this.appUtils.checkAndroidManifest(context);
                    ActivityIOCProvider.getInstance().setContainer(container);
                    this.initNotifications(context);
                    if (listener != null) {
                        listener.onInit(context, container);
                    }
                }
                catch (Exception e) {
                    if (this.logger != null) {
                        this.logger.error(0, (Throwable)e);
                        break block7;
                    }
                    SocializeLogger.e(e.getMessage(), e);
                }
            } else {
                ++this.initCount;
            }
        }
    }

    protected synchronized void initNotifications(Context context) {
        if (this.config.isNotificationsEnabled() && this.notificationChecker != null) {
            this.notificationChecker.checkRegistrations(context);
        }
    }

    protected synchronized void initEntityLoader() {
        EntityLoaderUtils entityLoaderUtils = (EntityLoaderUtils)this.container.getBean("entityLoaderUtils");
        entityLoaderUtils.initEntityLoader();
    }

    protected void verify3rdPartyAuthConfigured() {
        this.authProviderInfoBuilder.validateAll();
    }

    @Override
    public void saveSession(Context context) {
        this.userSystem.saveSession(context, this.session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear3rdPartySession(Context context, AuthProviderType type) {
        try {
            if (this.session != null) {
                AuthProviderInfo authProviderInfo;
                UserProviderCredentials userProviderCredentials;
                AuthProvider<AuthProviderInfo> provider = this.authProviders.getProvider(type);
                if (provider != null && (userProviderCredentials = this.session.getUserProviderCredentials(type)) != null && (authProviderInfo = userProviderCredentials.getAuthProviderInfo()) != null) {
                    provider.clearCache(context, authProviderInfo);
                }
                this.session.clear(type);
            }
        }
        finally {
            if (this.userSystem != null) {
                this.userSystem.clearSession(type);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearSessionCache(Context context) {
        try {
            if (this.session != null) {
                UserProviderCredentialsMap userProviderCredentialsMap = this.session.getUserProviderCredentials();
                if (userProviderCredentialsMap != null) {
                    Collection<UserProviderCredentials> values = userProviderCredentialsMap.values();
                    for (UserProviderCredentials userProviderCredentials : values) {
                        AuthProviderInfo authProviderInfo = userProviderCredentials.getAuthProviderInfo();
                        if (authProviderInfo == null) continue;
                        this.clear3rdPartySession(context, authProviderInfo.getType());
                    }
                }
                this.session = null;
            }
        }
        finally {
            if (this.userSystem != null) {
                this.userSystem.clearSession();
            }
        }
    }

    @Override
    public void destroy() {
        --this.initCount;
        if (this.initCount <= 0) {
            this.destroy(true);
        }
    }

    @Override
    public synchronized void destroy(boolean force) {
        if (force) {
            if (AsyncTaskManager.isManaged()) {
                AsyncTaskManager.terminateAll(10L, TimeUnit.SECONDS);
            }
            if (this.container != null) {
                if (this.logger != null && this.logger.isDebugEnabled()) {
                    this.logger.debug("Destroying IOC container");
                }
                this.container.destroy();
            }
            this.config.destroy();
            this.system.destroy();
            this.initCount = 0;
            this.initPaths = null;
            this.entityLoader = null;
            this.session = null;
            this.authProviders = null;
        } else {
            this.destroy();
        }
    }

    @Override
    public synchronized void authenticate(Context context, String consumerKey, String consumerSecret, AuthProviderInfo authProviderInfo, SocializeAuthListener authListener) {
        if (this.assertInitialized(context, authListener)) {
            this.userSystem.authenticate(context, consumerKey, consumerSecret, authProviderInfo, authListener, this);
        }
    }

    @Override
    public synchronized void authenticate(Context context, SocializeAuthListener authListener) {
        if (this.assertInitialized(context, authListener)) {
            this.userSystem.authenticate(context, authListener, this);
        }
    }

    @Override
    public synchronized SocializeSession authenticateSynchronous(final Context context) throws SocializeException {
        if (this.userSystem == null) {
            this.initCount = 0;
            this.init(context);
        }
        if (this.userSystem != null) {
            final CountDownLatch latch = new CountDownLatch(1);
            final ArrayList holder = new ArrayList(1);
            new Thread(){

                @Override
                public void run() {
                    try {
                        SocializeSession session = SocializeServiceImpl.this.userSystem.authenticateSynchronous(context);
                        SocializeServiceImpl.this.setSession(session);
                        latch.countDown();
                    }
                    catch (Exception e) {
                        holder.add(e);
                        latch.countDown();
                    }
                }
            }.start();
            try {
                if (!latch.await(20L, TimeUnit.SECONDS)) {
                    throw new SocializeException("Timeout while authenticating");
                }
            }
            catch (InterruptedException ignore) {
                // empty catch block
            }
            if (!holder.isEmpty()) {
                throw SocializeException.wrap((Throwable)holder.get(0));
            }
            return this.session;
        }
        throw new SocializeException("Socialize not initialized");
    }

    @Override
    @Deprecated
    public void authenticate(Context context, AuthProviderType authProviderType, SocializeAuthListener authListener, String ... permissions) {
        SocializeConfig config = this.getConfig();
        String consumerKey = config.getProperty("socialize.consumer.key");
        String consumerSecret = config.getProperty("socialize.consumer.secret");
        if (permissions.length > 0 && !Arrays.equals(permissions, FacebookFacade.DEFAULT_PERMISSIONS)) {
            HashSet<String> all = new HashSet<String>();
            all.addAll(Arrays.asList(permissions));
            all.addAll(Arrays.asList(FacebookFacade.DEFAULT_PERMISSIONS));
            permissions = all.toArray(new String[all.size()]);
        }
        Object authProviderInfo = this.authProviderInfoBuilder.getFactory(authProviderType).getInstance(permissions);
        this.authenticate(context, consumerKey, consumerSecret, (AuthProviderInfo)authProviderInfo, authListener);
    }

    @Override
    public void authenticateForRead(Context context, AuthProviderType authProviderType, SocializeAuthListener authListener, String ... permissions) {
        SocializeConfig config = this.getConfig();
        String consumerKey = config.getProperty("socialize.consumer.key");
        String consumerSecret = config.getProperty("socialize.consumer.secret");
        Object authProviderInfo = this.authProviderInfoBuilder.getFactory(authProviderType).getInstanceForRead(permissions);
        this.authenticate(context, consumerKey, consumerSecret, (AuthProviderInfo)authProviderInfo, authListener);
    }

    @Override
    public void authenticateForWrite(Context context, AuthProviderType authProviderType, SocializeAuthListener authListener, String ... permissions) {
        SocializeConfig config = this.getConfig();
        String consumerKey = config.getProperty("socialize.consumer.key");
        String consumerSecret = config.getProperty("socialize.consumer.secret");
        Object authProviderInfo = this.authProviderInfoBuilder.getFactory(authProviderType).getInstanceForWrite(permissions);
        this.authenticate(context, consumerKey, consumerSecret, (AuthProviderInfo)authProviderInfo, authListener);
    }

    @Override
    public synchronized void authenticate(Context context, String consumerKey, String consumerSecret, SocializeAuthListener authListener) {
        if (this.assertInitialized(context, authListener)) {
            this.userSystem.authenticate(context, consumerKey, consumerSecret, authListener, this);
        }
    }

    protected SocializeAuthProviderInfo newSocializeAuthProviderInfo() {
        return new SocializeAuthProviderInfo();
    }

    @Override
    public void authenticateKnownUser(Context context, UserProviderCredentials userProviderCredentials, SocializeAuthListener authListener) {
        if (this.assertInitialized(context, authListener)) {
            this.userSystem.authenticateKnownUser(context, userProviderCredentials, authListener, this);
        }
    }

    protected void logError(String message, Throwable error) {
        if (this.logger != null) {
            this.logger.error(message, error);
        } else {
            SocializeLogger.e(message, error);
        }
    }

    protected void logErrorMessage(String message) {
        if (this.logger != null) {
            this.logger.error(message);
        } else {
            System.err.println(message);
        }
    }

    protected Comment newComment() {
        return new Comment();
    }

    @Deprecated
    public boolean isInitialized() {
        return this.initCount > 0;
    }

    @Override
    public boolean isInitialized(Context context) {
        return this.initCount > 0 && this.container.getContext() == context;
    }

    @Override
    public boolean isAuthenticated() {
        return this.initCount > 0 && this.session != null;
    }

    @Override
    public boolean isAuthenticatedForRead(AuthProviderType providerType, String ... permissions) {
        return this.isAuthenticated(providerType, true, permissions);
    }

    @Override
    public boolean isAuthenticatedForWrite(AuthProviderType providerType, String ... permissions) {
        return this.isAuthenticated(providerType, false, permissions);
    }

    private boolean isAuthenticated(AuthProviderType providerType, boolean readOnly, String ... permissions) {
        if (this.isAuthenticated()) {
            if (providerType.equals((Object)AuthProviderType.SOCIALIZE)) {
                return true;
            }
            UserProviderCredentials userProviderCredentials = this.session.getUserProviderCredentials(providerType);
            if (userProviderCredentials != null) {
                AuthProviderInfo authProviderInfo = userProviderCredentials.getAuthProviderInfo();
                if (authProviderInfo != null) {
                    AuthProvider<AuthProviderInfo> provider = this.authProviders.getProvider(providerType);
                    if (readOnly) {
                        return provider.validateForRead(authProviderInfo, permissions);
                    }
                    return provider.validateForWrite(authProviderInfo, permissions);
                }
                return false;
            }
        }
        return false;
    }

    @Override
    @Deprecated
    public boolean isAuthenticated(AuthProviderType providerType) {
        return this.isAuthenticated(providerType, false, FacebookFacade.DEFAULT_PERMISSIONS);
    }

    protected boolean assertAuthenticated(SocializeListener listener) {
        if (this.asserter != null) {
            return this.asserter.assertAuthenticated(this, this.session, listener);
        }
        if (this.session != null) {
            return true;
        }
        if (listener != null) {
            if (this.logger != null && this.logger.isInitialized()) {
                listener.onError(new SocializeException(this.logger.getMessage(2)));
            } else {
                listener.onError(new SocializeException("Not authenticated"));
            }
        }
        if (this.logger != null && this.logger.isInitialized()) {
            this.logger.error(2);
        } else {
            System.err.println("Not authenticated");
        }
        return false;
    }

    protected boolean assertInitialized(Context context, SocializeListener listener) {
        if (this.asserter != null) {
            return this.asserter.assertInitialized(context, this, listener);
        }
        if (!this.isInitialized(context)) {
            if (listener != null) {
                if (this.logger != null && this.logger.isInitialized()) {
                    listener.onError(new SocializeException(this.logger.getMessage(1)));
                } else {
                    listener.onError(new SocializeException("Not initialized"));
                }
            }
            if (this.logger != null) {
                if (this.logger.isInitialized()) {
                    this.logger.error(1);
                } else {
                    this.logger.error("Socialize Not initialized!");
                }
            }
            return false;
        }
        return true;
    }

    @Override
    public SocializeSession getSession() {
        return this.session;
    }

    @Override
    public void setSession(SocializeSession session) {
        this.session = session;
    }

    public void setLogger(SocializeLogger logger) {
        this.logger = logger;
    }

    public SocializeConfig getConfig() {
        return this.config;
    }

    IOCContainer getContainer() {
        return this.container;
    }

    @Override
    public boolean canShare(Context context, ShareType shareType) {
        return this.shareSystem.canShare(context, shareType);
    }

    @Override
    public SocializeEntityLoader getEntityLoader() {
        return this.entityLoader;
    }

    @Override
    public SocializeSystem getSystem() {
        return this.system;
    }

    @Override
    public void setEntityLoader(SocializeEntityLoader entityLoader) {
        this.entityLoader = entityLoader;
    }

    @Override
    public SocializeLogger getLogger() {
        return this.logger;
    }

    @Override
    public void onPause(Activity context) {
        this.paused = true;
        if (this.locationProvider != null) {
            this.locationProvider.pause((Context)context);
        }
    }

    @Override
    public void onResume(final Activity context) {
        if (!Socialize.getSocialize().isInitialized((Context)context)) {
            Socialize.getSocialize().initAsync((Context)context, new SocializeInitListener(){

                @Override
                public void onError(SocializeException error) {
                    SocializeLogger.e("Error occurred on resume", error);
                }

                @Override
                public void onInit(Context ctx, IOCContainer container) {
                    SocializeServiceImpl.this.setContext(ctx);
                    if (SocializeServiceImpl.this.appUtils != null) {
                        SocializeServiceImpl.this.appUtils.onResume(ctx);
                    }
                    if (FacebookUtils.isAvailable(ctx)) {
                        try {
                            FacebookUtils.onResume(context, null);
                        }
                        catch (Exception e) {
                            SocializeLogger.e("Error occurred on resume", e);
                        }
                    }
                }
            });
        } else {
            if (this.paused && FacebookUtils.isAvailable((Context)context)) {
                try {
                    FacebookUtils.onResume(context, null);
                }
                catch (Exception e) {
                    SocializeLogger.e("Error occurred on resume", e);
                }
                this.paused = false;
            }
            this.setContext((Context)context);
            if (this.appUtils != null) {
                this.appUtils.onResume((Context)context);
            }
        }
    }

    @Override
    public void onCreate(Activity context, Bundle savedInstanceState) {
        if (this.loopyService != null) {
            this.loopyService.onCreate(context);
        }
    }

    @Override
    public void onDestroy(Activity context) {
        this.onContextDestroyed((Context)context);
        if (this.loopyService != null) {
            this.loopyService.onDestroy(context);
        }
    }

    @Override
    public void onStart(Activity context) {
        if (this.loopyService != null) {
            this.loopyService.onStart(context);
        }
    }

    @Override
    public void onStop(Activity context) {
        if (this.loopyService != null) {
            this.loopyService.onStop(context);
        }
    }

    protected void setShareSystem(ShareSystem shareSystem) {
        this.shareSystem = shareSystem;
    }

    protected void setUserSystem(UserSystem userSystem) {
        this.userSystem = userSystem;
    }

    protected void setAuthProviders(AuthProviders authProviders) {
        this.authProviders = authProviders;
    }

    protected void setAuthProviderInfoBuilder(AuthProviderInfoBuilder authProviderInfoBuilder) {
        this.authProviderInfoBuilder = authProviderInfoBuilder;
    }

    protected Intent newIntent(Activity context, Class<?> cls) {
        return new Intent((Context)context, cls);
    }

    public static class InitTask
    extends ManagedAsyncTask<Void, Void, IOCContainer> {
        private WeakReference<Context> context;
        private String[] paths;
        private Exception error;
        private SocializeInitListener listener;
        private SocializeServiceImpl service;
        private SocializeLogger logger;

        public InitTask(SocializeServiceImpl service, Context context, String[] paths, SocializeInitListener listener, SocializeLogger logger) {
            this.context = new WeakReference<Context>(context);
            this.paths = paths;
            this.listener = listener;
            this.service = service;
            this.logger = logger;
        }

        public IOCContainer doInBackground(Void ... params) {
            try {
                return this.service.initWithContainer((Context)this.context.get(), (SocializeInitListener)null, this.paths);
            }
            catch (Exception e) {
                this.error = e;
                return null;
            }
        }

        @Override
        public void onPostExecuteManaged(IOCContainer result) {
            if (result == null) {
                String errorMessage = "Failed to initialize Socialize instance";
                if (this.listener != null) {
                    if (this.error != null) {
                        this.listener.onError(SocializeException.wrap(this.error));
                    } else {
                        this.listener.onError(new SocializeException("Failed to initialize Socialize instance"));
                    }
                } else if (this.logger != null) {
                    if (this.error != null) {
                        this.logger.error("Failed to initialize Socialize instance", (Throwable)this.error);
                    } else {
                        this.logger.error("Failed to initialize Socialize instance");
                    }
                } else if (this.error != null) {
                    SocializeLogger.e("Failed to initialize Socialize instance", this.error);
                } else {
                    System.err.println("Failed to initialize Socialize instance");
                }
            } else if (this.listener != null) {
                this.listener.onInit((Context)this.context.get(), result);
            }
        }
    }
}

