/*
 * Decompiled with CFR 0.152.
 */
package com.socialize;

import android.app.Activity;
import android.content.Context;
import android.widget.CompoundButton;
import com.socialize.SocializeActionProxy;
import com.socialize.api.action.like.LikeOptions;
import com.socialize.api.action.like.LikeUtilsProxy;
import com.socialize.entity.Entity;
import com.socialize.entity.User;
import com.socialize.listener.like.IsLikedListener;
import com.socialize.listener.like.LikeAddListener;
import com.socialize.listener.like.LikeDeleteListener;
import com.socialize.listener.like.LikeGetListener;
import com.socialize.listener.like.LikeListListener;
import com.socialize.networks.SocialNetwork;
import com.socialize.ui.actionbutton.LikeButtonListener;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;

public class LikeUtils {
    static LikeUtilsProxy proxy = (LikeUtilsProxy)Proxy.newProxyInstance(LikeUtilsProxy.class.getClassLoader(), new Class[]{LikeUtilsProxy.class}, (InvocationHandler)new SocializeActionProxy("likeUtils"));

    public static LikeOptions getUserLikeOptions(Context context) {
        return proxy.getUserLikeOptions(context);
    }

    public static void like(Activity context, Entity entity, LikeAddListener listener) {
        proxy.like(context, entity, listener);
    }

    public static void like(Activity context, Entity entity, LikeOptions likeOptions, LikeAddListener listener, SocialNetwork ... networks) {
        proxy.like(context, entity, likeOptions, listener, networks);
    }

    public static void unlike(Activity context, String entityKey, LikeDeleteListener listener) {
        proxy.unlike(context, entityKey, listener);
    }

    public static void getLike(Activity context, String entityKey, LikeGetListener listener) {
        proxy.getLike(context, entityKey, listener);
    }

    public static void getLike(Activity context, long id, LikeGetListener listener) {
        proxy.getLike(context, id, listener);
    }

    public static void isLiked(Activity context, String entityKey, IsLikedListener listener) {
        proxy.getLike(context, entityKey, (LikeGetListener)listener);
    }

    public static void getLikesByUser(Activity context, User user, int start, int end, LikeListListener listener) {
        proxy.getLikesByUser(context, user, start, end, listener);
    }

    public static void getLikesByEntity(Activity context, String entityKey, int start, int end, LikeListListener listener) {
        proxy.getLikesByEntity(context, entityKey, start, end, listener);
    }

    public static void getLikesByApplication(Activity context, int start, int end, LikeListListener listener) {
        proxy.getLikesByApplication(context, start, end, listener);
    }

    public static void makeLikeButton(Activity context, CompoundButton button, Entity entity, LikeButtonListener listener) {
        proxy.makeLikeButton(context, button, entity, listener);
    }
}

