/*
 * Decompiled with CFR 0.152.
 */
package com.socialize;

import android.app.Activity;
import android.content.Context;
import com.socialize.SocializeActionProxy;
import com.socialize.api.action.comment.CommentOptions;
import com.socialize.api.action.comment.CommentUtilsProxy;
import com.socialize.entity.Entity;
import com.socialize.entity.User;
import com.socialize.listener.comment.CommentAddListener;
import com.socialize.listener.comment.CommentDeleteListener;
import com.socialize.listener.comment.CommentGetListener;
import com.socialize.listener.comment.CommentListListener;
import com.socialize.networks.SocialNetwork;
import com.socialize.ui.comment.OnCommentViewActionListener;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;

public class CommentUtils {
    static CommentUtilsProxy proxy = (CommentUtilsProxy)Proxy.newProxyInstance(CommentUtilsProxy.class.getClassLoader(), new Class[]{CommentUtilsProxy.class}, (InvocationHandler)new SocializeActionProxy("commentUtils"));

    public static CommentOptions getUserCommentOptions(Context context) {
        return proxy.getUserCommentOptions(context);
    }

    public static void addComment(Activity context, Entity entity, String text, CommentAddListener listener) {
        proxy.addComment(context, entity, text, listener);
    }

    public static void deleteComment(Activity context, long id, CommentDeleteListener listener) {
        proxy.deleteComment(context, id, listener);
    }

    public static void addComment(Activity context, Entity entity, String text, CommentOptions commentOptions, CommentAddListener listener, SocialNetwork ... networks) {
        proxy.addComment(context, entity, text, commentOptions, listener, networks);
    }

    public static void getComment(Activity context, CommentGetListener listener, long id) {
        proxy.getComment(context, id, listener);
    }

    public static void getComments(Activity context, CommentListListener listener, long ... ids) {
        proxy.getComments(context, listener, ids);
    }

    public static void getCommentsByUser(Activity context, User user, int start, int end, CommentListListener listener) {
        proxy.getCommentsByUser(context, user, start, end, listener);
    }

    public static void getCommentsByEntity(Activity context, String entityKey, int start, int end, CommentListListener listener) {
        proxy.getCommentsByEntity(context, entityKey, start, end, listener);
    }

    public static void getCommentsByApplication(Activity context, int start, int end, CommentListListener listener) {
        proxy.getCommentsByApplication(context, start, end, listener);
    }

    public static void showCommentView(Activity context, Entity entity, OnCommentViewActionListener listener) {
        proxy.showCommentView(context, entity, listener);
    }

    public static void showCommentView(Activity context, Entity entity) {
        proxy.showCommentView(context, entity);
    }
}

