/*
 * Decompiled with CFR 0.152.
 */
package com.snappydb;

import android.content.Context;
import android.text.TextUtils;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.snappydb.DB;
import com.snappydb.DBFactory;
import com.snappydb.SnappydbException;
import java.io.File;

public class SnappyDB {
    private static volatile DB singleton = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DB with(Context context) throws SnappydbException {
        if (singleton != null && singleton.isOpen()) return singleton;
        Class<SnappyDB> clazz = SnappyDB.class;
        synchronized (SnappyDB.class) {
            if (singleton != null && singleton.isOpen()) return singleton;
            singleton = new Builder(context).build();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return singleton;
        }
    }

    public static class Builder {
        private final Context context;
        private String name;
        private String dir;
        private Kryo kryo;

        public Builder(Context context) {
            if (null == context) {
                throw new IllegalArgumentException("Context must not be null.");
            }
            this.context = context.getApplicationContext();
            this.kryo = new Kryo();
            this.kryo.setAsmEnabled(true);
        }

        public Builder name(String dbName) {
            if (TextUtils.isEmpty((CharSequence)dbName)) {
                throw new IllegalArgumentException("Database name must not be empty or null.");
            }
            this.name = dbName;
            return this;
        }

        public Builder directory(String absolutePath) {
            if (TextUtils.isEmpty((CharSequence)absolutePath)) {
                throw new IllegalArgumentException("Database directory must not be empty or null.");
            }
            this.dir = absolutePath;
            return this;
        }

        public Builder registerSerializers(Class type, Serializer serializer) {
            if (null == type) {
                throw new IllegalArgumentException("Class type must not be null.");
            }
            if (null == serializer) {
                throw new IllegalArgumentException("Serializer must not be null.");
            }
            this.kryo.register(type, serializer);
            return this;
        }

        public DB build() throws SnappydbException {
            if (null != this.dir) {
                File f = new File(this.dir);
                if ((f.mkdirs() || f.isDirectory()) && f.canWrite()) {
                    if (null != this.name) {
                        return DBFactory.open(this.dir, this.name, this.kryo);
                    }
                    return DBFactory.open(this.dir, this.kryo);
                }
                throw new IllegalStateException("Can't create or access directory " + this.dir);
            }
            if (null != this.name) {
                return DBFactory.open(this.context, this.name, this.kryo);
            }
            return DBFactory.open(this.context, this.kryo);
        }
    }
}

