/*
 * Decompiled with CFR 0.152.
 */
package com.smartsheet.api.models;

import com.smartsheet.api.internal.util.QueryUtil;
import java.util.HashMap;
import java.util.Map;

public class PaginationParameters {
    private boolean includeAll;
    private Integer pageSize;
    private Integer page;
    private String lastKey;
    private Integer maxItems;
    private String paginationType;

    public PaginationParameters() {
    }

    public PaginationParameters(boolean includeAll, Integer pageSize, Integer page) {
        this.includeAll = includeAll;
        this.pageSize = pageSize;
        this.page = page;
    }

    public PaginationParameters(String paginationType, String lastKey, Integer maxItems) {
        this.paginationType = paginationType;
        this.lastKey = lastKey;
        this.maxItems = maxItems;
    }

    public boolean isIncludeAll() {
        return this.includeAll;
    }

    public PaginationParameters setIncludeAll(boolean includeAll) {
        this.includeAll = includeAll;
        return this;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public PaginationParameters setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public Integer getPage() {
        return this.page;
    }

    public PaginationParameters setPage(Integer page) {
        this.page = page;
        return this;
    }

    public String getPaginationType() {
        return this.paginationType;
    }

    public PaginationParameters setPaginationType(String paginationType) {
        this.paginationType = paginationType;
        return this;
    }

    public String getLastKey() {
        return this.lastKey;
    }

    public PaginationParameters setLastKey(String lastKey) {
        this.lastKey = lastKey;
        return this;
    }

    public Integer getMaxItems() {
        return this.maxItems;
    }

    public PaginationParameters setMaxItems(Integer maxItems) {
        this.maxItems = maxItems;
        return this;
    }

    public String toQueryString() {
        Map<String, Object> parameters = this.toHashMap();
        return QueryUtil.generateUrl(null, parameters);
    }

    public Map<String, Object> toHashMap() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (this.paginationType != null && "token".equals(this.paginationType)) {
            parameters.put("paginationType", this.paginationType);
            if (this.lastKey != null) {
                parameters.put("lastKey", this.lastKey);
            }
            if (this.maxItems != null) {
                parameters.put("maxItems", this.maxItems);
            }
            return parameters;
        }
        if (this.includeAll) {
            parameters.put("includeAll", Boolean.toString(this.includeAll));
            return parameters;
        }
        parameters.put("pageSize", this.pageSize);
        parameters.put("page", this.page);
        return parameters;
    }

    public static class PaginationParametersBuilder {
        private boolean includeAll;
        private Integer pageSize;
        private Integer page;
        private String lastKey;
        private Integer maxItems;
        private String paginationType;

        public boolean isIncludeAll() {
            return this.includeAll;
        }

        public PaginationParametersBuilder setIncludeAll(boolean includeAll) {
            this.includeAll = includeAll;
            return this;
        }

        public Integer getPage() {
            return this.page;
        }

        public PaginationParametersBuilder setPage(Integer page) {
            this.page = page;
            return this;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public PaginationParametersBuilder setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public String getPaginationType() {
            return this.paginationType;
        }

        public PaginationParametersBuilder setPaginationType(String paginationType) {
            this.paginationType = paginationType;
            return this;
        }

        public String getLastKey() {
            return this.lastKey;
        }

        public PaginationParametersBuilder setLastKey(String lastKey) {
            this.lastKey = lastKey;
            return this;
        }

        public Integer getMaxItems() {
            return this.maxItems;
        }

        public PaginationParametersBuilder setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public PaginationParameters build() {
            PaginationParameters pagination = new PaginationParameters();
            pagination.setIncludeAll(this.includeAll);
            pagination.setPageSize(this.pageSize);
            pagination.setPage(this.page);
            pagination.setLastKey(this.lastKey);
            pagination.setMaxItems(this.maxItems);
            pagination.setPaginationType(this.paginationType);
            return pagination;
        }
    }
}

