/*
 * Decompiled with CFR 0.152.
 */
package com.smartsheet.api.internal.util;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class QueryUtil {
    private QueryUtil() {
    }

    public static <T> String generateCommaSeparatedList(@Nullable Collection<T> list) {
        if (list == null || list.isEmpty()) {
            return "";
        }
        return list.stream().map(Object::toString).collect(Collectors.joining(","));
    }

    public static String generateUrl(@Nullable String baseUrl, @Nullable Map<String, ?> parameters) {
        if (baseUrl == null) {
            baseUrl = "";
        }
        return baseUrl + QueryUtil.generateQueryString(parameters);
    }

    private static String generateQueryString(@Nullable Map<String, ?> parameters) {
        if (parameters == null || parameters.isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, ?> entry : parameters.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null || entry.getValue().toString().isEmpty()) continue;
            String encodedQueryParam = URLEncoder.encode(entry.getKey(), StandardCharsets.UTF_8);
            String encodedQueryValue = URLEncoder.encode(entry.getValue().toString(), StandardCharsets.UTF_8);
            result.append('&').append(encodedQueryParam).append("=").append(encodedQueryValue);
        }
        return result.length() == 0 ? "" : "?" + result.substring(1);
    }
}

