/*
 * Decompiled with CFR 0.152.
 */
package com.smartsheet.api.internal;

import com.smartsheet.api.AssetShareResources;
import com.smartsheet.api.ContactResources;
import com.smartsheet.api.EventResources;
import com.smartsheet.api.FavoriteResources;
import com.smartsheet.api.FolderResources;
import com.smartsheet.api.GroupResources;
import com.smartsheet.api.HomeResources;
import com.smartsheet.api.ImageUrlResources;
import com.smartsheet.api.PassthroughResources;
import com.smartsheet.api.ReportResources;
import com.smartsheet.api.SearchResources;
import com.smartsheet.api.ServerInfoResources;
import com.smartsheet.api.SheetResources;
import com.smartsheet.api.SightResources;
import com.smartsheet.api.Smartsheet;
import com.smartsheet.api.TemplateResources;
import com.smartsheet.api.TokenResources;
import com.smartsheet.api.Trace;
import com.smartsheet.api.UserResources;
import com.smartsheet.api.WebhookResources;
import com.smartsheet.api.WorkspaceResources;
import com.smartsheet.api.internal.AssetShareResourcesImpl;
import com.smartsheet.api.internal.ContactResourcesImpl;
import com.smartsheet.api.internal.EventResourcesImpl;
import com.smartsheet.api.internal.FavoriteResourcesImpl;
import com.smartsheet.api.internal.FolderResourcesImpl;
import com.smartsheet.api.internal.GroupResourcesImpl;
import com.smartsheet.api.internal.HomeResourcesImpl;
import com.smartsheet.api.internal.ImageUrlResourcesImpl;
import com.smartsheet.api.internal.PassthroughResourcesImpl;
import com.smartsheet.api.internal.ReportResourcesImpl;
import com.smartsheet.api.internal.SearchResourcesImpl;
import com.smartsheet.api.internal.ServerInfoResourcesImpl;
import com.smartsheet.api.internal.SheetResourcesImpl;
import com.smartsheet.api.internal.SightResourcesImpl;
import com.smartsheet.api.internal.TemplateResourcesImpl;
import com.smartsheet.api.internal.TokenResourcesImpl;
import com.smartsheet.api.internal.UserResourcesImpl;
import com.smartsheet.api.internal.WebhookResourcesImpl;
import com.smartsheet.api.internal.WorkspaceResourcesImpl;
import com.smartsheet.api.internal.http.AndroidHttpClient;
import com.smartsheet.api.internal.http.DefaultHttpClient;
import com.smartsheet.api.internal.http.HttpClient;
import com.smartsheet.api.internal.json.JacksonJsonSerializer;
import com.smartsheet.api.internal.json.JsonSerializer;
import com.smartsheet.api.internal.util.CleanerUtil;
import com.smartsheet.api.internal.util.Util;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.http.impl.client.HttpClients;

public class SmartsheetImpl
implements Smartsheet {
    private final URI baseURI;
    private final AtomicReference<String> accessToken;
    private final HttpClient httpClient;
    private final JsonSerializer jsonSerializer;
    private final AtomicReference<String> assumedUser;
    private final AtomicReference<String> changeAgent;
    private final AtomicReference<String> userAgent;
    private final AtomicReference<HomeResources> home;
    private final AtomicReference<WorkspaceResources> workspaces;
    private final AtomicReference<FolderResources> folders;
    private final AtomicReference<TemplateResources> templates;
    private final AtomicReference<SheetResources> sheets;
    private final AtomicReference<SightResources> sights;
    private final AtomicReference<UserResources> users;
    private final AtomicReference<GroupResources> groups;
    private final AtomicReference<SearchResources> search;
    private final AtomicReference<ReportResources> reports;
    private final AtomicReference<ServerInfoResources> serverInfo;
    private final AtomicReference<FavoriteResources> favorites;
    private final AtomicReference<TokenResources> tokens;
    private final AtomicReference<ContactResources> contacts;
    private final AtomicReference<ImageUrlResources> imageUrls;
    private final AtomicReference<WebhookResources> webhooks;
    private final AtomicReference<PassthroughResources> passthrough;
    private final AtomicReference<EventResources> events;
    private final AtomicReference<AssetShareResources> assetShares;
    private static final String INVALID_OPERATION_FOR_CLASS = "Invalid operation for class ";

    public SmartsheetImpl(String baseURI, String accessToken) {
        this(baseURI, accessToken, null, null);
    }

    public SmartsheetImpl(String baseURI, String accessToken, HttpClient httpClient, JsonSerializer jsonSerializer) {
        Util.throwIfNull(baseURI);
        Util.throwIfEmpty(baseURI);
        this.baseURI = URI.create(baseURI);
        this.accessToken = new AtomicReference<String>(accessToken);
        this.jsonSerializer = jsonSerializer == null ? new JacksonJsonSerializer() : jsonSerializer;
        this.httpClient = httpClient == null ? new DefaultHttpClient(HttpClients.createDefault(), this.jsonSerializer) : httpClient;
        CleanerUtil.register(this, CleanerUtil.closeQuietly(this.httpClient));
        this.assumedUser = new AtomicReference<Object>(null);
        this.changeAgent = new AtomicReference<Object>(null);
        this.userAgent = new AtomicReference<String>(this.generateUserAgent(null));
        this.home = new AtomicReference();
        this.workspaces = new AtomicReference();
        this.folders = new AtomicReference();
        this.templates = new AtomicReference();
        this.sheets = new AtomicReference();
        this.sights = new AtomicReference();
        this.favorites = new AtomicReference();
        this.users = new AtomicReference();
        this.groups = new AtomicReference();
        this.search = new AtomicReference();
        this.reports = new AtomicReference();
        this.serverInfo = new AtomicReference();
        this.tokens = new AtomicReference();
        this.contacts = new AtomicReference();
        this.imageUrls = new AtomicReference();
        this.webhooks = new AtomicReference();
        this.passthrough = new AtomicReference();
        this.events = new AtomicReference();
        this.assetShares = new AtomicReference();
    }

    URI getBaseURI() {
        return this.baseURI;
    }

    String getAccessToken() {
        return this.accessToken.get();
    }

    @Override
    public void setAccessToken(String accessToken) {
        this.accessToken.set(accessToken);
    }

    JsonSerializer getJsonSerializer() {
        return this.jsonSerializer;
    }

    HttpClient getHttpClient() {
        return this.httpClient;
    }

    String getAssumedUser() {
        return this.assumedUser.get();
    }

    @Override
    public void setAssumedUser(String assumedUser) {
        this.assumedUser.set(assumedUser);
    }

    String getChangeAgent() {
        return this.changeAgent.get();
    }

    @Override
    public void setChangeAgent(String changeAgent) {
        this.changeAgent.set(changeAgent);
    }

    public String getUserAgent() {
        return this.userAgent.get();
    }

    @Override
    public void setUserAgent(String userAgent) {
        this.userAgent.set(this.generateUserAgent(userAgent));
    }

    @Override
    public void setMaxRetryTimeMillis(long maxRetryTimeMillis) {
        if (this.httpClient instanceof DefaultHttpClient) {
            ((DefaultHttpClient)this.httpClient).setMaxRetryTimeMillis(maxRetryTimeMillis);
        } else if (this.httpClient instanceof AndroidHttpClient) {
            ((AndroidHttpClient)this.httpClient).setMaxRetryTimeMillis(maxRetryTimeMillis);
        } else {
            throw new UnsupportedOperationException(INVALID_OPERATION_FOR_CLASS + String.valueOf(this.httpClient.getClass()));
        }
    }

    @Override
    public void setTraces(Trace ... traces) {
        if (!(this.httpClient instanceof DefaultHttpClient)) {
            throw new UnsupportedOperationException(INVALID_OPERATION_FOR_CLASS + String.valueOf(this.httpClient.getClass()));
        }
        ((DefaultHttpClient)this.httpClient).setTraces(traces);
    }

    @Override
    public void setTracePrettyPrint(boolean pretty) {
        if (!(this.httpClient instanceof DefaultHttpClient)) {
            throw new UnsupportedOperationException(INVALID_OPERATION_FOR_CLASS + String.valueOf(this.httpClient.getClass()));
        }
        ((DefaultHttpClient)this.httpClient).setTracePrettyPrint(pretty);
    }

    @Override
    @Deprecated(since="3.4.0", forRemoval=true)
    public HomeResources homeResources() {
        if (this.home.get() == null) {
            this.home.compareAndSet(null, new HomeResourcesImpl(this));
        }
        return this.home.get();
    }

    @Override
    public WorkspaceResources workspaceResources() {
        if (this.workspaces.get() == null) {
            this.workspaces.compareAndSet(null, new WorkspaceResourcesImpl(this));
        }
        return this.workspaces.get();
    }

    @Override
    public FolderResources folderResources() {
        if (this.folders.get() == null) {
            this.folders.compareAndSet(null, new FolderResourcesImpl(this));
        }
        return this.folders.get();
    }

    @Override
    public TemplateResources templateResources() {
        if (this.templates.get() == null) {
            this.templates.compareAndSet(null, new TemplateResourcesImpl(this));
        }
        return this.templates.get();
    }

    @Override
    public SheetResources sheetResources() {
        if (this.sheets.get() == null) {
            this.sheets.compareAndSet(null, new SheetResourcesImpl(this));
        }
        return this.sheets.get();
    }

    @Override
    public SightResources sightResources() {
        if (this.sights.get() == null) {
            this.sights.compareAndSet(null, new SightResourcesImpl(this));
        }
        return this.sights.get();
    }

    @Override
    public FavoriteResources favoriteResources() {
        if (this.favorites.get() == null) {
            this.favorites.compareAndSet(null, new FavoriteResourcesImpl(this));
        }
        return this.favorites.get();
    }

    @Override
    public UserResources userResources() {
        if (this.users.get() == null) {
            this.users.compareAndSet(null, new UserResourcesImpl(this));
        }
        return this.users.get();
    }

    @Override
    public GroupResources groupResources() {
        if (this.groups.get() == null) {
            this.groups.compareAndSet(null, new GroupResourcesImpl(this));
        }
        return this.groups.get();
    }

    @Override
    public SearchResources searchResources() {
        if (this.search.get() == null) {
            this.search.compareAndSet(null, new SearchResourcesImpl(this));
        }
        return this.search.get();
    }

    @Override
    public ReportResources reportResources() {
        if (this.reports.get() == null) {
            this.reports.compareAndSet(null, new ReportResourcesImpl(this));
        }
        return this.reports.get();
    }

    @Override
    public ServerInfoResources serverInfoResources() {
        if (this.serverInfo.get() == null) {
            this.serverInfo.compareAndSet(null, new ServerInfoResourcesImpl(this));
        }
        return this.serverInfo.get();
    }

    @Override
    public TokenResources tokenResources() {
        if (this.tokens.get() == null) {
            this.tokens.compareAndSet(null, new TokenResourcesImpl(this));
        }
        return this.tokens.get();
    }

    @Override
    public ContactResources contactResources() {
        if (this.contacts.get() == null) {
            this.contacts.compareAndSet(null, new ContactResourcesImpl(this));
        }
        return this.contacts.get();
    }

    @Override
    public ImageUrlResources imageUrlResources() {
        if (this.imageUrls.get() == null) {
            this.imageUrls.compareAndSet(null, new ImageUrlResourcesImpl(this));
        }
        return this.imageUrls.get();
    }

    @Override
    public WebhookResources webhookResources() {
        if (this.webhooks.get() == null) {
            this.webhooks.compareAndSet(null, new WebhookResourcesImpl(this));
        }
        return this.webhooks.get();
    }

    @Override
    public PassthroughResources passthroughResources() {
        if (this.passthrough.get() == null) {
            this.passthrough.compareAndSet(null, new PassthroughResourcesImpl(this));
        }
        return this.passthrough.get();
    }

    @Override
    public EventResources eventResources() {
        if (this.events.get() == null) {
            this.events.compareAndSet(null, new EventResourcesImpl(this));
        }
        return this.events.get();
    }

    @Override
    public AssetShareResources assetShareResources() {
        if (this.assetShares.get() == null) {
            this.assetShares.compareAndSet(null, new AssetShareResourcesImpl(this));
        }
        return this.assetShares.get();
    }

    private String generateUserAgent(String userAgent) {
        String title = null;
        String thisVersion = null;
        if (userAgent == null) {
            StackTraceElement[] callers = Thread.currentThread().getStackTrace();
            String module = null;
            String callerClass = null;
            for (int stackIdx = callers.length - 1; stackIdx >= 0; --stackIdx) {
                callerClass = callers[stackIdx].getClassName();
                try {
                    String classUrlPath;
                    int jarSeparator;
                    String classFilePath;
                    URL classUrl;
                    Class<?> clazz = Class.forName(callerClass);
                    ClassLoader classLoader = clazz.getClassLoader();
                    if (classLoader == null || (classUrl = classLoader.getResource(classFilePath = callerClass.replace(".", "/") + ".class")) == null || (jarSeparator = (classUrlPath = classUrl.getPath()).indexOf(33)) <= 0) continue;
                    module = classUrlPath.substring(0, jarSeparator);
                    module = module.substring(module.lastIndexOf(47) + 1);
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            userAgent = module + "!" + callerClass;
        }
        try {
            Properties properties = new Properties();
            properties.load(this.getClass().getClassLoader().getResourceAsStream("sdk.properties"));
            thisVersion = properties.getProperty("sdk.version");
            title = properties.getProperty("sdk.name");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return title + "/" + thisVersion + "/" + (String)userAgent + "/" + System.getProperty("os.name") + " " + System.getProperty("java.vm.name") + " " + System.getProperty("java.vendor") + " " + System.getProperty("java.version");
    }
}

