/*
 * Decompiled with CFR 0.152.
 */
package com.smartsheet.api.internal;

import com.smartsheet.api.ShareResources;
import com.smartsheet.api.SightResources;
import com.smartsheet.api.SmartsheetException;
import com.smartsheet.api.internal.AbstractResources;
import com.smartsheet.api.internal.ShareResourcesImpl;
import com.smartsheet.api.internal.SmartsheetImpl;
import com.smartsheet.api.internal.util.QueryUtil;
import com.smartsheet.api.internal.util.Util;
import com.smartsheet.api.models.ContainerDestination;
import com.smartsheet.api.models.PagedResult;
import com.smartsheet.api.models.PaginationParameters;
import com.smartsheet.api.models.Sight;
import com.smartsheet.api.models.SightPublish;
import com.smartsheet.api.models.enums.SightInclusion;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public class SightResourcesImpl
extends AbstractResources
implements SightResources {
    private ShareResources shares;
    private static final String SIGHTS = "sights";

    public SightResourcesImpl(SmartsheetImpl smartsheet) {
        super(smartsheet);
        this.shares = new ShareResourcesImpl(smartsheet, SIGHTS);
    }

    @Override
    public PagedResult<Sight> listSights(PaginationParameters paging, Date modifiedSince) throws SmartsheetException {
        Object path = SIGHTS;
        Map<Object, Object> parameters = new HashMap();
        if (paging != null) {
            parameters = paging.toHashMap();
        }
        if (modifiedSince != null) {
            String isoDate = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").format(modifiedSince);
            parameters.put("modifiedSince", isoDate);
        }
        path = (String)path + QueryUtil.generateUrl(null, parameters);
        return this.listResourcesWithWrapper((String)path, Sight.class);
    }

    @Override
    public Sight getSight(long sightId) throws SmartsheetException {
        return this.getSight(sightId, null, null);
    }

    @Override
    public Sight getSight(long sightId, Integer level) throws SmartsheetException {
        return this.getSight(sightId, null, level);
    }

    @Override
    public Sight getSight(long sightId, EnumSet<SightInclusion> includes, Integer level) throws SmartsheetException {
        String path = "sights/" + sightId;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("level", level);
        parameters.put("include", QueryUtil.generateCommaSeparatedList(includes));
        path = path + QueryUtil.generateUrl(null, parameters);
        return this.getResource(path, Sight.class);
    }

    @Override
    public Sight updateSight(Sight sight) throws SmartsheetException {
        Util.throwIfNull(sight);
        return this.updateResource("sights/" + String.valueOf(sight.getId()), Sight.class, sight);
    }

    @Override
    public void deleteSight(long sightId) throws SmartsheetException {
        this.deleteResource("sights/" + sightId, Sight.class);
    }

    @Override
    public Sight copySight(long sightId, ContainerDestination destination) throws SmartsheetException {
        return this.createResource("sights/" + sightId + "/copy", Sight.class, destination);
    }

    @Override
    public Sight moveSight(long sightId, ContainerDestination destination) throws SmartsheetException {
        return this.createResource("sights/" + sightId + "/move", Sight.class, destination);
    }

    @Override
    public SightPublish getPublishStatus(long sightId) throws SmartsheetException {
        return this.getResource("sights/" + sightId + "/publish", SightPublish.class);
    }

    @Override
    public SightPublish setPublishStatus(long sightId, SightPublish sightPublish) throws SmartsheetException {
        Util.throwIfNull(sightPublish);
        return this.updateResource("sights/" + sightId + "/publish", SightPublish.class, sightPublish);
    }

    @Override
    public ShareResources shareResources() {
        return this.shares;
    }
}

