/*
 * Copyright (C) 2025 Smartsheet
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.smartsheet.api.models.format;

/**
 * An enumeration representing the available Bold state for a format.
 */
public enum Bold {
    NONE(false),
    ON(true),
    ;
    private final boolean bold;

    /**
     * The default setting when the {@link Format} for {@link Bold} is null;
     */
    public static final Bold DEFAULT = NONE;

    Bold(boolean bold) {
        this.bold = bold;
    }

    /**
     * @return the bold
     */
    public boolean isBold() {
        return bold;
    }

}
