/*
 * Copyright (C) 2025 Smartsheet
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.smartsheet.api.models.enums;

/**
 * Represents the column symbols.
 *
 * @see <a href="http://help.smartsheet.com/customer/portal/articles/504619-column-types#symbols">Symbols Help</a>
 */
public enum Symbol {
    /**
     * Represents the FLAG symbol.
     */
    FLAG,

    /**
     * Represents the STAR symbol.
     */
    STAR,

    /**
     * Represents the HARVEY_BALLS symbol.
     */
    HARVEY_BALLS,

    /**
     * Represents the PRIORITY symbol.
     */
    PRIORITY,

    /**
     * Represents the RYG symbol.
     */
    RYG,

    /**
     * Represents the PRIORITY_HML symbol.
     */
    PRIORITY_HML,

    /**
     * Represents the DECISION_SYMBOLS symbol.
     */
    DECISION_SYMBOLS,

    /**
     * Represents the DECISION_SHAPES symbol.
     */
    DECISION_SHAPES,

    /**
     * Represents the VCR symbol.
     */
    VCR,

    /**
     * Represents the RYGB symbol.
     */
    RYGB,

    /**
     * Represents the RYGG symbol.
     */
    RYGG,

    /**
     * Represents the WEATHER symbol.
     */
    WEATHER,

    /**
     * Represents the PROGRESS symbol.
     */
    PROGRESS,

    /**
     * Represents the ARROWS_3_WAY symbol.
     */
    ARROWS_3_WAY,

    /**
     * Represents the ARROWS_4_WAY symbol.
     */
    ARROWS_4_WAY,

    /**
     * Represents the ARROWS_5_WAY symbol.
     */
    ARROWS_5_WAY,

    /**
     * Represents the DIRECTIONS_3_WAY symbol.
     */
    DIRECTIONS_3_WAY,

    /**
     * Represents the DIRECTIONS_4_WAY symbol.
     */
    DIRECTIONS_4_WAY,

    /**
     * Represents the SKI symbol.
     */
    SKI,

    /**
     * Represents the SIGNAL symbol.
     */
    SIGNAL,

    /**
     * Represents the STAR_RATING symbol.
     */
    STAR_RATING,

    /**
     * Represents the HEARTS symbol.
     */
    HEARTS,

    /**
     * Represents the MONEY symbol.
     */
    MONEY,

    /**
     * Represents the EFFORT symbol.
     */
    EFFORT,

    /**
     * Represents the PAIN symbol.
     */
    PAIN,
}
