/*
 * Decompiled with CFR 0.152.
 */
package com.smartsheet.api.oauth;

import com.smartsheet.api.internal.http.DefaultHttpClient;
import com.smartsheet.api.internal.http.HttpClient;
import com.smartsheet.api.internal.json.JacksonJsonSerializer;
import com.smartsheet.api.internal.json.JsonSerializer;
import com.smartsheet.api.internal.oauth.OAuthFlowImpl;
import com.smartsheet.api.internal.util.Util;
import com.smartsheet.api.oauth.OAuthFlow;

public class OAuthFlowBuilder {
    public static final String DEFAULT_AUTHORIZATION_URL = "https://www.smartsheet.com/b/authorize";
    public static final String DEFAULT_TOKEN_URL = "https://api.smartsheet.com/2.0/token";
    private HttpClient httpClient;
    private JsonSerializer jsonSerializer;
    private String clientId;
    private String clientSecret;
    private String redirectURL;
    private String authorizationURL;
    private String tokenURL;

    public OAuthFlowBuilder setHttpClient(HttpClient httpClient) {
        Util.throwIfNull(httpClient);
        this.httpClient = httpClient;
        return this;
    }

    public OAuthFlowBuilder setJsonSerializer(JsonSerializer jsonSerializer) {
        Util.throwIfNull(jsonSerializer);
        this.jsonSerializer = jsonSerializer;
        return this;
    }

    public OAuthFlowBuilder setClientId(String clientId) {
        Util.throwIfNull(clientId);
        this.clientId = clientId;
        return this;
    }

    public OAuthFlowBuilder setClientSecret(String clientSecret) {
        Util.throwIfNull(clientSecret);
        this.clientSecret = clientSecret;
        return this;
    }

    public OAuthFlowBuilder setRedirectURL(String redirectURL) {
        Util.throwIfNull(redirectURL);
        this.redirectURL = redirectURL;
        return this;
    }

    public OAuthFlowBuilder setAuthorizationURL(String authorizationURL) {
        Util.throwIfNull(authorizationURL);
        this.authorizationURL = authorizationURL;
        return this;
    }

    public OAuthFlowBuilder setTokenURL(String tokenURL) {
        Util.throwIfNull(tokenURL);
        this.tokenURL = tokenURL;
        return this;
    }

    public static String getDefaultAuthorizationUrl() {
        return DEFAULT_AUTHORIZATION_URL;
    }

    public static String getDefaultTokenUrl() {
        return DEFAULT_TOKEN_URL;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public JsonSerializer getJsonSerializer() {
        return this.jsonSerializer;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getRedirectURL() {
        return this.redirectURL;
    }

    public String getAuthorizationURL() {
        return this.authorizationURL;
    }

    public String getTokenURL() {
        return this.tokenURL;
    }

    public OAuthFlow build() {
        if (this.httpClient == null) {
            this.httpClient = new DefaultHttpClient();
        }
        if (this.tokenURL == null) {
            this.tokenURL = DEFAULT_TOKEN_URL;
        }
        if (this.authorizationURL == null) {
            this.authorizationURL = DEFAULT_AUTHORIZATION_URL;
        }
        if (this.jsonSerializer == null) {
            this.jsonSerializer = new JacksonJsonSerializer();
        }
        if (this.clientId == null || this.clientSecret == null || this.redirectURL == null) {
            throw new IllegalStateException();
        }
        return new OAuthFlowImpl(this.clientId, this.clientSecret, this.redirectURL, this.authorizationURL, this.tokenURL, this.httpClient, this.jsonSerializer);
    }
}

