/*
 * Decompiled with CFR 0.152.
 */
package com.smartsheet.api.internal.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.binary.Hex;

public class StreamUtil {
    public static final int ONE_MB = 0x100000;
    public static final int ONE_KB = 1024;
    public static final int TEN_KB = 10240;

    public static byte[] readBytesFromStream(InputStream source) throws IOException {
        return StreamUtil.readBytesFromStream(source, 0x100000);
    }

    public static byte[] readBytesFromStream(InputStream source, int bufferSize) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        StreamUtil.copyContentIntoOutputStream(source, buffer, bufferSize, true);
        return buffer.toByteArray();
    }

    public static long copyContentIntoOutputStream(InputStream source, OutputStream target, int bufferSize, boolean readToEOF) throws IOException {
        int bytesRead;
        byte[] tempBuf = new byte[Math.max(1024, bufferSize)];
        long bytesWritten = 0L;
        while ((bytesRead = source.read(tempBuf)) >= 0) {
            target.write(tempBuf, 0, bytesRead);
            bytesWritten += (long)bytesRead;
            if (readToEOF) continue;
            break;
        }
        return bytesWritten;
    }

    public static InputStream cloneContent(InputStream source, int readbackSize, ByteArrayOutputStream target) throws IOException {
        if (source == null) {
            return null;
        }
        if (source.markSupported()) {
            readbackSize = Math.max(10240, readbackSize);
            source.mark(readbackSize);
            StreamUtil.copyContentIntoOutputStream(source, target, readbackSize, false);
            source.reset();
            return source;
        }
        StreamUtil.copyContentIntoOutputStream(source, target, 0x100000, true);
        byte[] fullContentBytes = target.toByteArray();
        return new ByteArrayInputStream(fullContentBytes);
    }

    public static InputStream cloneContent(InputStream source, long readbackSize, ByteArrayOutputStream target) throws IOException {
        return StreamUtil.cloneContent(source, (int)Math.min(Integer.MAX_VALUE, readbackSize), target);
    }

    public static String toUtf8StringOrHex(ByteArrayOutputStream byteStream, int maxLen) {
        String result;
        if (maxLen == -1) {
            maxLen = Integer.MAX_VALUE;
        }
        try {
            result = byteStream.toString(StandardCharsets.UTF_8);
        }
        catch (Exception notUtf8) {
            result = Hex.encodeHexString((byte[])byteStream.toByteArray());
        }
        int resultLen = result != null ? result.length() : 0;
        String suffix = resultLen > maxLen ? "..." : "";
        return resultLen == 0 ? "" : result.substring(0, Math.min(resultLen, maxLen)) + suffix;
    }
}

