/*
 * Decompiled with CFR 0.152.
 */
package com.smartsheet.api.internal;

import com.smartsheet.api.ReportResources;
import com.smartsheet.api.ShareResources;
import com.smartsheet.api.SmartsheetException;
import com.smartsheet.api.internal.AbstractResources;
import com.smartsheet.api.internal.ShareResourcesImpl;
import com.smartsheet.api.internal.SmartsheetImpl;
import com.smartsheet.api.internal.util.QueryUtil;
import com.smartsheet.api.models.PagedResult;
import com.smartsheet.api.models.PaginationParameters;
import com.smartsheet.api.models.Report;
import com.smartsheet.api.models.ReportPublish;
import com.smartsheet.api.models.SheetEmail;
import com.smartsheet.api.models.enums.ReportInclusion;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public class ReportResourcesImpl
extends AbstractResources
implements ReportResources {
    private ShareResources shares;
    private static final String REPORTS_PATH = "reports/";

    public ReportResourcesImpl(SmartsheetImpl smartsheet) {
        super(smartsheet);
        this.shares = new ShareResourcesImpl(smartsheet, "reports");
    }

    @Override
    public Report getReport(long reportId, EnumSet<ReportInclusion> includes, Integer pageSize, Integer page) throws SmartsheetException {
        return this.getReport(reportId, includes, pageSize, page, null);
    }

    @Override
    public Report getReport(long reportId, EnumSet<ReportInclusion> includes, Integer pageSize, Integer page, Integer level) throws SmartsheetException {
        String path = REPORTS_PATH + reportId;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("include", QueryUtil.generateCommaSeparatedList(includes));
        if (pageSize != null) {
            parameters.put("pageSize", pageSize.toString());
        }
        if (page != null) {
            parameters.put("page", page.toString());
        }
        if (level != null) {
            parameters.put("level", level);
        }
        path = path + QueryUtil.generateUrl(null, parameters);
        return this.getResource(path, Report.class);
    }

    @Override
    public void sendReport(long reportId, SheetEmail email) throws SmartsheetException {
        this.createResource(REPORTS_PATH + reportId + "/emails", SheetEmail.class, email);
    }

    @Override
    public PagedResult<Report> listReports(PaginationParameters pagination) throws SmartsheetException {
        return this.listReports(pagination, null);
    }

    @Override
    public PagedResult<Report> listReports(PaginationParameters pagination, Date modifiedSince) throws SmartsheetException {
        Object path = "reports";
        Map<Object, Object> parameters = new HashMap();
        if (pagination != null) {
            parameters = pagination.toHashMap();
        }
        if (modifiedSince != null) {
            String isoDate = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").format(modifiedSince);
            parameters.put("modifiedSince", isoDate);
        }
        path = (String)path + QueryUtil.generateUrl(null, parameters);
        return this.listResourcesWithWrapper((String)path, Report.class);
    }

    @Override
    public void getReportAsExcel(long id, OutputStream outputStream) throws SmartsheetException {
        this.getResourceAsFile(REPORTS_PATH + id, "application/vnd.ms-excel", outputStream);
    }

    @Override
    public void getReportAsCsv(long id, OutputStream outputStream) throws SmartsheetException {
        this.getResourceAsFile(REPORTS_PATH + id, "text/csv", outputStream);
    }

    @Override
    public ReportPublish getPublishStatus(long id) throws SmartsheetException {
        return this.getResource(REPORTS_PATH + id + "/publish", ReportPublish.class);
    }

    @Override
    public ReportPublish updatePublishStatus(long id, ReportPublish reportPublish) throws SmartsheetException {
        return this.updateResource(REPORTS_PATH + id + "/publish", ReportPublish.class, reportPublish);
    }

    @Override
    public ShareResources shareResources() {
        return this.shares;
    }
}

