/*
 * Decompiled with CFR 0.152.
 */
package com.smartsheet.api.models;

import com.smartsheet.api.models.UserModelWithName;
import com.smartsheet.api.models.enums.SeatType;
import java.time.ZonedDateTime;

public class User
extends UserModelWithName {
    private Long planId;
    private SeatType seatType;
    private ZonedDateTime seatTypeLastChangedAt;
    private Boolean isInternal;
    private ZonedDateTime provisionalExpirationDate;

    public Long getPlanId() {
        return this.planId;
    }

    public void setPlanId(Long planId) {
        this.planId = planId;
    }

    public SeatType getSeatType() {
        return this.seatType;
    }

    public void setSeatType(SeatType seatType) {
        this.seatType = seatType;
    }

    public ZonedDateTime getSeatTypeLastChangedAt() {
        return this.seatTypeLastChangedAt;
    }

    public void setSeatTypeLastChangedAt(ZonedDateTime seatTypeLastChangedAt) {
        this.seatTypeLastChangedAt = seatTypeLastChangedAt;
    }

    public ZonedDateTime getProvisionalExpirationDate() {
        return this.provisionalExpirationDate;
    }

    public void setProvisionalExpirationDate(ZonedDateTime provisionalExpirationDate) {
        this.provisionalExpirationDate = provisionalExpirationDate;
    }

    public Boolean getIsInternal() {
        return this.isInternal;
    }

    public void setIsInternal(Boolean isInternal) {
        this.isInternal = isInternal;
    }

    public static class NewGroupMemberBuilder {
        private String email;

        public String getEmail() {
            return this.email;
        }

        public NewGroupMemberBuilder setEmail(String email) {
            this.email = email;
            return this;
        }

        public User build() {
            if (this.email == null) {
                throw new InstantiationError("An email address must be set.");
            }
            User user = new User();
            user.setEmail(this.email);
            return user;
        }
    }

    public static class UpdateUserBuilder {
        private Boolean admin;
        private Boolean licensedSheetCreator;
        private Boolean groupAdmin;
        private Boolean resourceViewer;
        private String firstName;
        private String lastName;
        private Long id;

        public Long getUserId() {
            return this.id;
        }

        public UpdateUserBuilder setUserId(Long userId) {
            this.id = userId;
            return this;
        }

        public UpdateUserBuilder setAdmin(Boolean admin) {
            this.admin = admin;
            return this;
        }

        public UpdateUserBuilder setLicensedSheetCreator(Boolean licensedSheetCreator) {
            this.licensedSheetCreator = licensedSheetCreator;
            return this;
        }

        public Boolean getAdmin() {
            return this.admin;
        }

        public Boolean getLicensedSheetCreator() {
            return this.licensedSheetCreator;
        }

        public String getFirstName() {
            return this.firstName;
        }

        public UpdateUserBuilder setFirstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public String getLastName() {
            return this.lastName;
        }

        public UpdateUserBuilder setLastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public Boolean getGroupAdmin() {
            return this.groupAdmin;
        }

        public UpdateUserBuilder setGroupAdmin(Boolean groupAdmin) {
            this.groupAdmin = groupAdmin;
            return this;
        }

        public Boolean getResourceViewer() {
            return this.resourceViewer;
        }

        public UpdateUserBuilder setResourceViewer(Boolean resourceViewer) {
            this.resourceViewer = resourceViewer;
            return this;
        }

        public User build() {
            if (this.admin == null || this.licensedSheetCreator == null || this.id == null) {
                throw new InstantiationError("An admin, licensed sheet creator and user Id must be set");
            }
            User user = new User();
            user.setFirstName(this.firstName);
            user.setLastName(this.lastName);
            user.setAdmin(this.admin);
            user.setLicensedSheetCreator(this.licensedSheetCreator);
            user.setGroupAdmin(this.groupAdmin);
            user.setResourceViewer(this.resourceViewer);
            user.setId(this.id);
            return user;
        }
    }

    public static class AddUserBuilder {
        private Boolean admin;
        private String emailAddress;
        private Boolean licensedSheetCreator;
        private Boolean groupAdmin;
        private Boolean resourceViewer;
        private String firstName;
        private String lastName;

        public AddUserBuilder setAdmin(Boolean admin) {
            this.admin = admin;
            return this;
        }

        public AddUserBuilder setLicensedSheetCreator(Boolean licensedSheetCreator) {
            this.licensedSheetCreator = licensedSheetCreator;
            return this;
        }

        public AddUserBuilder setEmail(String email) {
            this.emailAddress = email;
            return this;
        }

        public Boolean getAdmin() {
            return this.admin;
        }

        public Boolean getLicensedSheetCreator() {
            return this.licensedSheetCreator;
        }

        public String getFirstName() {
            return this.firstName;
        }

        public AddUserBuilder setFirstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public String getLastName() {
            return this.lastName;
        }

        public AddUserBuilder setLastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public Boolean getGroupAdmin() {
            return this.groupAdmin;
        }

        public AddUserBuilder setGroupAdmin(Boolean groupAdmin) {
            this.groupAdmin = groupAdmin;
            return this;
        }

        public Boolean getResourceViewer() {
            return this.resourceViewer;
        }

        public AddUserBuilder setResourceViewer(Boolean resourceViewer) {
            this.resourceViewer = resourceViewer;
            return this;
        }

        public User build() {
            if (this.admin == null || this.emailAddress == null || this.licensedSheetCreator == null) {
                throw new InstantiationError();
            }
            User user = new User();
            user.setAdmin(this.admin);
            user.setLicensedSheetCreator(this.licensedSheetCreator);
            user.setGroupAdmin(this.groupAdmin);
            user.setResourceViewer(this.resourceViewer);
            user.setFirstName(this.firstName);
            user.setLastName(this.lastName);
            user.setEmail(this.emailAddress);
            return user;
        }
    }
}

