/*
 * Decompiled with CFR 0.152.
 */
package com.smartsheet.api.internal.http;

import com.smartsheet.api.Trace;
import com.smartsheet.api.internal.http.HttpClient;
import com.smartsheet.api.internal.http.HttpClientException;
import com.smartsheet.api.internal.http.HttpEntity;
import com.smartsheet.api.internal.http.HttpEntitySnapshot;
import com.smartsheet.api.internal.http.HttpMethod;
import com.smartsheet.api.internal.http.HttpPatch;
import com.smartsheet.api.internal.http.HttpRequest;
import com.smartsheet.api.internal.http.HttpResponse;
import com.smartsheet.api.internal.http.RequestAndResponseData;
import com.smartsheet.api.internal.json.JacksonJsonSerializer;
import com.smartsheet.api.internal.json.JsonSerializer;
import com.smartsheet.api.internal.util.StreamUtil;
import com.smartsheet.api.internal.util.Util;
import com.smartsheet.api.models.Error;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.http.Header;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.NonRepeatableRequestException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHttpClient
implements HttpClient {
    protected static final Logger logger = LoggerFactory.getLogger(DefaultHttpClient.class);
    protected static final String JSON_MIME_TYPE = ContentType.APPLICATION_JSON.getMimeType();
    protected JsonSerializer jsonSerializer;
    protected long maxRetryTimeMillis = 15000L;
    private final CloseableHttpClient httpClient;
    private CloseableHttpResponse apacheHttpResponse;
    private static final Set<Trace> REQUEST_RESPONSE_SUMMARY = Set.of(Trace.RequestHeaders, Trace.RequestBodySummary, Trace.ResponseHeaders, Trace.ResponseBodySummary);
    private static final boolean TRACE_PRETTY_PRINT_DEFAULT = Boolean.parseBoolean(System.getProperty("Smartsheet.trace.pretty", "true"));
    private static final Set<Trace> TRACE_DEFAULT_TRACE_SET = Trace.parse(System.getProperty("Smartsheet.trace.parts"));
    private static PrintWriter traceWriter;
    private final Random random = new Random();
    private final Set<Trace> traces = new HashSet<Trace>(TRACE_DEFAULT_TRACE_SET);
    private boolean tracePrettyPrint = TRACE_PRETTY_PRINT_DEFAULT;
    private static final String LOG_ARG = "{}";
    private static final String ERROR_OCCURRED = "Error occurred.";

    public DefaultHttpClient() {
        this(HttpClients.createDefault(), new JacksonJsonSerializer());
    }

    public DefaultHttpClient(CloseableHttpClient httpClient, JsonSerializer jsonSerializer) {
        this.httpClient = Util.throwIfNull(httpClient);
        this.jsonSerializer = jsonSerializer;
    }

    public void logRequest(HttpRequestBase request, HttpEntitySnapshot requestEntity, HttpResponse response, HttpEntitySnapshot responseEntity, long durationMillis) throws IOException {
        logger.info("{} {}, Response Code:{}, Request completed in {} ms", new Object[]{request.getMethod(), request.getURI(), response.getStatusCode(), durationMillis});
        logger.debug(LOG_ARG, (Object)RequestAndResponseData.of(request, requestEntity, response, responseEntity, REQUEST_RESPONSE_SUMMARY));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpResponse request(HttpRequest smartsheetRequest) throws HttpClientException {
        HttpResponse smartsheetResponse;
        boolean canRetryRequest;
        Util.throwIfNull(smartsheetRequest);
        if (smartsheetRequest.getUri() == null) {
            throw new IllegalArgumentException("A Request URI is required.");
        }
        long start = System.currentTimeMillis();
        InputStream bodyStream = null;
        if (smartsheetRequest.getEntity() != null && smartsheetRequest.getEntity().getContent() != null) {
            bodyStream = smartsheetRequest.getEntity().getContent();
        }
        boolean bl = canRetryRequest = bodyStream == null || bodyStream.markSupported();
        if (!canRetryRequest) {
            try {
                bodyStream = new ByteArrayInputStream(StreamUtil.readBytesFromStream(bodyStream));
                smartsheetRequest.getEntity().getContent().close();
                smartsheetRequest.getEntity().setContent(bodyStream);
                canRetryRequest = true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        while (true) {
            int attempt = 0;
            HttpRequestBase apacheHttpRequest = this.createApacheRequest(smartsheetRequest);
            if (smartsheetRequest.getHeaders() != null) {
                for (Map.Entry<String, String> header : smartsheetRequest.getHeaders().entrySet()) {
                    apacheHttpRequest.addHeader(header.getKey(), header.getValue());
                }
            }
            HttpEntitySnapshot responseEntityCopy = null;
            HttpEntitySnapshot requestEntityCopy = this.copyRequestEntity(smartsheetRequest, apacheHttpRequest);
            if (canRetryRequest && bodyStream != null) {
                bodyStream.mark((int)smartsheetRequest.getEntity().getContentLength());
            }
            smartsheetResponse = new HttpResponse();
            BasicHttpContext context = new BasicHttpContext();
            try {
                long startTime = System.currentTimeMillis();
                this.apacheHttpResponse = this.httpClient.execute((HttpUriRequest)apacheHttpRequest, (HttpContext)context);
                long endTime = System.currentTimeMillis();
                HttpEntitySnapshot newResponseCopy = this.updateWithResponse(apacheHttpRequest, (HttpContext)context, smartsheetResponse);
                if (newResponseCopy != null) {
                    responseEntityCopy = newResponseCopy;
                }
                long responseTime = endTime - startTime;
                this.logRequest(apacheHttpRequest, requestEntityCopy, smartsheetResponse, responseEntityCopy, responseTime);
                if (this.traces.size() > 0) {
                    RequestAndResponseData requestAndResponseData = RequestAndResponseData.of(apacheHttpRequest, requestEntityCopy, smartsheetResponse, responseEntityCopy, this.traces);
                    traceWriter.println(requestAndResponseData.toString(this.tracePrettyPrint));
                }
                if (smartsheetResponse.getStatusCode() == 200) break;
                InputStream contentStream = smartsheetResponse.getEntity().getContent();
                if (!contentStream.markSupported()) {
                    contentStream = new ByteArrayInputStream(StreamUtil.readBytesFromStream(contentStream));
                    smartsheetResponse.getEntity().getContent().close();
                    smartsheetResponse.getEntity().setContent(contentStream);
                }
                try {
                    contentStream.mark((int)smartsheetResponse.getEntity().getContentLength());
                    long timeSpent = System.currentTimeMillis() - start;
                    if (!this.shouldRetry(++attempt, timeSpent, smartsheetResponse)) {
                        break;
                    }
                }
                finally {
                    if (bodyStream != null) {
                        bodyStream.reset();
                    }
                    contentStream.reset();
                }
                this.releaseConnection();
                continue;
            }
            catch (ClientProtocolException e) {
                logger.warn("ClientProtocolException " + e.getMessage());
                logger.warn(LOG_ARG, (Object)RequestAndResponseData.of(apacheHttpRequest, requestEntityCopy, smartsheetResponse, responseEntityCopy, REQUEST_RESPONSE_SUMMARY));
                try {
                    if (canRetryRequest && e.getCause() instanceof NonRepeatableRequestException) {
                        if (smartsheetRequest.getEntity() == null) continue;
                        smartsheetRequest.getEntity().getContent().reset();
                        continue;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw new HttpClientException(ERROR_OCCURRED, e);
            }
            catch (NoHttpResponseException e) {
                block28: {
                    logger.warn("NoHttpResponseException {}", (Object)e.getMessage());
                    logger.warn(LOG_ARG, (Object)RequestAndResponseData.of(apacheHttpRequest, requestEntityCopy, smartsheetResponse, responseEntityCopy, REQUEST_RESPONSE_SUMMARY));
                    try {
                        if (canRetryRequest && (smartsheetRequest.getMethod() == HttpMethod.POST || smartsheetRequest.getMethod() == HttpMethod.PATCH)) {
                            if (smartsheetRequest.getEntity() == null) continue;
                            smartsheetRequest.getEntity().getContent().reset();
                            continue;
                        }
                        break block28;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                        break block28;
                    }
                    continue;
                }
                throw new HttpClientException(ERROR_OCCURRED, e);
            }
            catch (IOException e) {
                logger.warn(LOG_ARG, (Object)RequestAndResponseData.of(apacheHttpRequest, requestEntityCopy, smartsheetResponse, responseEntityCopy, REQUEST_RESPONSE_SUMMARY));
                throw new HttpClientException(ERROR_OCCURRED, e);
            }
            break;
        }
        return smartsheetResponse;
    }

    private HttpEntitySnapshot copyRequestEntity(HttpRequest smartsheetRequest, HttpRequestBase apacheHttpRequest) {
        HttpEntity entity = smartsheetRequest.getEntity();
        HttpEntitySnapshot requestEntityCopy = null;
        if (apacheHttpRequest instanceof HttpEntityEnclosingRequestBase && entity != null && entity.getContent() != null) {
            try {
                requestEntityCopy = new HttpEntitySnapshot(entity);
            }
            catch (IOException iox) {
                logger.error("failed to make copy of original request entity", (Throwable)iox);
            }
            InputStreamEntity streamEntity = new InputStreamEntity(entity.getContent(), entity.getContentLength());
            streamEntity.setChunked(false);
            ((HttpEntityEnclosingRequestBase)apacheHttpRequest).setEntity((org.apache.http.HttpEntity)streamEntity);
        }
        return requestEntityCopy;
    }

    @Nullable
    private HttpEntitySnapshot updateWithResponse(HttpRequestBase apacheHttpRequest, HttpContext context, HttpResponse smartsheetResponse) throws IOException {
        Object httpRequest = context.getAttribute("http.request");
        if (httpRequest != null && HttpRequestWrapper.class.isAssignableFrom(httpRequest.getClass())) {
            Header[] actualRequest = (Header[])httpRequest;
            switch (HttpMethod.valueOf(actualRequest.getMethod())) {
                case GET: 
                case POST: 
                case PUT: 
                case DELETE: 
                case PATCH: {
                    apacheHttpRequest.setHeaders(actualRequest.getAllHeaders());
                    break;
                }
            }
        }
        smartsheetResponse.setHeaders(new HashMap<String, String>());
        for (Header header : this.apacheHttpResponse.getAllHeaders()) {
            smartsheetResponse.getHeaders().put(header.getName(), header.getValue());
        }
        smartsheetResponse.setStatus(this.apacheHttpResponse.getStatusLine().getStatusCode(), this.apacheHttpResponse.getStatusLine().toString());
        if (this.apacheHttpResponse.getEntity() != null) {
            HttpEntity httpEntity = new HttpEntity();
            httpEntity.setContentType(this.apacheHttpResponse.getEntity().getContentType().getValue());
            httpEntity.setContentLength(this.apacheHttpResponse.getEntity().getContentLength());
            httpEntity.setContent(this.apacheHttpResponse.getEntity().getContent());
            smartsheetResponse.setEntity(httpEntity);
            return new HttpEntitySnapshot(httpEntity);
        }
        return null;
    }

    public HttpRequestBase createApacheRequest(HttpRequest smartsheetRequest) {
        Object apacheHttpRequest;
        switch (smartsheetRequest.getMethod()) {
            case GET: {
                apacheHttpRequest = new HttpGet(smartsheetRequest.getUri());
                break;
            }
            case POST: {
                apacheHttpRequest = new HttpPost(smartsheetRequest.getUri());
                break;
            }
            case PUT: {
                apacheHttpRequest = new HttpPut(smartsheetRequest.getUri());
                break;
            }
            case DELETE: {
                apacheHttpRequest = new HttpDelete(smartsheetRequest.getUri());
                break;
            }
            case PATCH: {
                apacheHttpRequest = new HttpPatch(smartsheetRequest.getUri());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Request method " + String.valueOf((Object)smartsheetRequest.getMethod()) + " is not supported!");
            }
        }
        RequestConfig.Builder builder = RequestConfig.custom();
        if (apacheHttpRequest.getConfig() != null) {
            builder = RequestConfig.copy((RequestConfig)apacheHttpRequest.getConfig());
        }
        builder.setRedirectsEnabled(true);
        RequestConfig config = builder.build();
        apacheHttpRequest.setConfig(config);
        return apacheHttpRequest;
    }

    public void setMaxRetryTimeMillis(long maxRetryTimeMillis) {
        this.maxRetryTimeMillis = maxRetryTimeMillis;
    }

    public long calcBackoff(int previousAttempts, long totalElapsedTimeMillis, Error error) {
        long backoffMillis = (long)(Math.pow(2.0, previousAttempts) * 1000.0) + (long)this.random.nextInt(1000);
        if (totalElapsedTimeMillis + backoffMillis > this.maxRetryTimeMillis) {
            logger.info("Elapsed time {} + backoff time {} exceeds max retry time {}, exiting retry loop", new Object[]{totalElapsedTimeMillis, backoffMillis, this.maxRetryTimeMillis});
            return -1L;
        }
        return backoffMillis;
    }

    public boolean shouldRetry(int previousAttempts, long totalElapsedTimeMillis, HttpResponse response) {
        Error error;
        String contentType = response.getEntity().getContentType();
        if (contentType != null && !contentType.startsWith(JSON_MIME_TYPE)) {
            return false;
        }
        try {
            error = this.jsonSerializer.deserialize(Error.class, response.getEntity().getContent());
        }
        catch (IOException e) {
            return false;
        }
        switch (error.getErrorCode()) {
            case 4001: 
            case 4002: 
            case 4003: 
            case 4004: {
                break;
            }
            default: {
                return false;
            }
        }
        long backoffMillis = this.calcBackoff(previousAttempts, totalElapsedTimeMillis, error);
        if (backoffMillis < 0L) {
            return false;
        }
        logger.info("HttpError StatusCode={}: Retrying in {} milliseconds", (Object)response.getStatusCode(), (Object)backoffMillis);
        try {
            Thread.sleep(backoffMillis);
        }
        catch (InterruptedException e) {
            logger.warn("sleep interrupted", (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public void close() throws IOException {
        this.httpClient.close();
    }

    @Override
    public void releaseConnection() {
        if (this.apacheHttpResponse != null) {
            try {
                this.apacheHttpResponse.close();
                this.apacheHttpResponse = null;
            }
            catch (IOException e) {
                logger.error("error closing Apache HttpResponse", (Throwable)e);
            }
        }
    }

    public void setTraces(Trace ... traces) {
        this.traces.clear();
        for (Trace trace : traces) {
            if (trace.addReplacements(this.traces)) continue;
            this.traces.add(trace);
        }
    }

    public void setTracePrettyPrint(boolean pretty) {
        this.tracePrettyPrint = pretty;
    }

    public static void setTraceStream(OutputStream traceStream) {
        traceWriter = new PrintWriter(traceStream, true);
    }

    static {
        DefaultHttpClient.setTraceStream(System.out);
        if (!TRACE_DEFAULT_TRACE_SET.isEmpty()) {
            traceWriter.println("default trace logging - pretty:" + TRACE_PRETTY_PRINT_DEFAULT + " parts:" + String.valueOf(TRACE_DEFAULT_TRACE_SET));
        }
    }
}

