/*
 * Decompiled with CFR 0.152.
 */
package com.smartsheet.api.internal;

import com.smartsheet.api.SheetUpdateRequestResources;
import com.smartsheet.api.SmartsheetException;
import com.smartsheet.api.internal.AbstractResources;
import com.smartsheet.api.internal.SmartsheetImpl;
import com.smartsheet.api.internal.util.QueryUtil;
import com.smartsheet.api.models.PagedResult;
import com.smartsheet.api.models.PaginationParameters;
import com.smartsheet.api.models.SentUpdateRequest;
import com.smartsheet.api.models.UpdateRequest;
import java.util.HashMap;
import java.util.Map;

public class SheetUpdateRequestResourcesImpl
extends AbstractResources
implements SheetUpdateRequestResources {
    private static final String SHEETS_PATH = "sheets/";
    private static final String UPDATE_REQUESTS = "updaterequests";

    public SheetUpdateRequestResourcesImpl(SmartsheetImpl smartsheet) {
        super(smartsheet);
    }

    @Override
    public PagedResult<UpdateRequest> listUpdateRequests(long sheetId, PaginationParameters paging) throws SmartsheetException {
        String path = SHEETS_PATH + sheetId + "/updaterequests";
        Map<Object, Object> parameters = new HashMap();
        if (paging != null) {
            parameters = paging.toHashMap();
        }
        path = path + QueryUtil.generateUrl(null, parameters);
        return this.listResourcesWithWrapper(path, UpdateRequest.class);
    }

    @Override
    public UpdateRequest getUpdateRequest(long sheetId, long updateRequestId) throws SmartsheetException {
        String path = SHEETS_PATH + sheetId + "/updaterequests/" + updateRequestId;
        return this.getResource(path, UpdateRequest.class);
    }

    @Override
    public UpdateRequest createUpdateRequest(long sheetId, UpdateRequest updateRequest) throws SmartsheetException {
        String path = SHEETS_PATH + sheetId + "/updaterequests";
        return this.createResource(path, UpdateRequest.class, updateRequest);
    }

    @Override
    public void deleteUpdateRequest(long sheetId, long updateRequestId) throws SmartsheetException {
        String path = SHEETS_PATH + sheetId + "/updaterequests/" + updateRequestId;
        this.deleteResource(path, UpdateRequest.class);
    }

    @Override
    public UpdateRequest updateUpdateRequest(long sheetId, UpdateRequest updateRequest) throws SmartsheetException {
        String path = SHEETS_PATH + sheetId + "/updaterequests/" + updateRequest.getId();
        return this.updateResource(path, UpdateRequest.class, updateRequest);
    }

    @Override
    public PagedResult<SentUpdateRequest> listSentUpdateRequests(long sheetId, PaginationParameters paging) throws SmartsheetException {
        String path = SHEETS_PATH + sheetId + "/sentupdaterequests";
        Map<Object, Object> parameters = new HashMap();
        if (paging != null) {
            parameters = paging.toHashMap();
        }
        path = path + QueryUtil.generateUrl(null, parameters);
        return this.listResourcesWithWrapper(path, SentUpdateRequest.class);
    }

    @Override
    public SentUpdateRequest getSentUpdateRequest(long sheetId, long sentUpdateRequestId) throws SmartsheetException {
        String path = SHEETS_PATH + sheetId + "/sentupdaterequests/" + sentUpdateRequestId;
        return this.getResource(path, SentUpdateRequest.class);
    }

    @Override
    public void deleteSentUpdateRequest(long sheetId, long sentUpdateRequestId) throws SmartsheetException {
        String path = SHEETS_PATH + sheetId + "/sentupdaterequests/" + sentUpdateRequestId;
        this.deleteResource(path, SentUpdateRequest.class);
    }
}

