/*
 * Decompiled with CFR 0.152.
 */
package com.smartsheet.api.internal;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.smartsheet.api.ImageUrlResources;
import com.smartsheet.api.SmartsheetException;
import com.smartsheet.api.internal.AbstractResources;
import com.smartsheet.api.internal.SmartsheetImpl;
import com.smartsheet.api.internal.http.HttpEntity;
import com.smartsheet.api.internal.http.HttpMethod;
import com.smartsheet.api.internal.http.HttpRequest;
import com.smartsheet.api.internal.http.HttpResponse;
import com.smartsheet.api.internal.util.Util;
import com.smartsheet.api.models.ImageUrl;
import com.smartsheet.api.models.ImageUrlMap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;

public class ImageUrlResourcesImpl
extends AbstractResources
implements ImageUrlResources {
    public ImageUrlResourcesImpl(SmartsheetImpl smartsheet) {
        super(smartsheet);
    }

    @Override
    public ImageUrlMap getImageUrls(List<ImageUrl> requestUrls) throws SmartsheetException {
        Util.throwIfNull(requestUrls);
        HttpRequest request = this.createHttpRequest(this.smartsheet.getBaseURI().resolve("imageurls"), HttpMethod.POST);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.smartsheet.getJsonSerializer().serialize(requestUrls, baos);
        HttpEntity entity = new HttpEntity();
        entity.setContentType("application/json");
        entity.setContent(new ByteArrayInputStream(baos.toByteArray()));
        entity.setContentLength(baos.size());
        request.setEntity(entity);
        HttpResponse response = this.smartsheet.getHttpClient().request(request);
        ImageUrlMap obj = null;
        switch (response.getStatusCode()) {
            case 200: {
                try {
                    obj = this.smartsheet.getJsonSerializer().deserialize(ImageUrlMap.class, response.getEntity().getContent());
                    break;
                }
                catch (JsonParseException e) {
                    throw new SmartsheetException((Exception)((Object)e));
                }
                catch (JsonMappingException e) {
                    throw new SmartsheetException((Exception)((Object)e));
                }
                catch (IOException e) {
                    throw new SmartsheetException(e);
                }
            }
            default: {
                this.handleError(response);
            }
        }
        this.smartsheet.getHttpClient().releaseConnection();
        return obj;
    }
}

