/*
 * Decompiled with CFR 0.152.
 */
package com.smartsheet.api.internal;

import com.smartsheet.api.AssetShareResources;
import com.smartsheet.api.SmartsheetException;
import com.smartsheet.api.internal.AbstractResources;
import com.smartsheet.api.internal.SmartsheetImpl;
import com.smartsheet.api.internal.util.QueryUtil;
import com.smartsheet.api.internal.util.Util;
import com.smartsheet.api.models.CreateShareRequest;
import com.smartsheet.api.models.ListAssetSharesResponse;
import com.smartsheet.api.models.ShareResponse;
import com.smartsheet.api.models.UpdateShareRequest;
import java.util.HashMap;
import java.util.List;

public class AssetShareResourcesImpl
extends AbstractResources
implements AssetShareResources {
    private static final String SHARES_PATH = "shares";
    private static final String ASSET_ID_PARAM = "assetId";
    private static final String ASSET_TYPE_PARAM = "assetType";

    public AssetShareResourcesImpl(SmartsheetImpl smartsheet) {
        super(smartsheet);
    }

    @Override
    public ListAssetSharesResponse<ShareResponse> listShares(String assetId, String assetType, String lastKey, Long maxItems, String sharingInclude) throws SmartsheetException {
        Object path = SHARES_PATH;
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        queryParameters.put(ASSET_ID_PARAM, assetId);
        queryParameters.put(ASSET_TYPE_PARAM, assetType);
        if (lastKey != null) {
            queryParameters.put("lastKey", lastKey);
        }
        if (maxItems != null) {
            queryParameters.put("maxItems", maxItems);
        }
        if (sharingInclude != null) {
            queryParameters.put("sharingInclude", sharingInclude);
        }
        path = (String)path + QueryUtil.generateUrl(null, queryParameters);
        return this.listAssetSharesWithTokenPagination((String)path, ShareResponse.class);
    }

    @Override
    public ShareResponse getShare(String shareId, String assetId, String assetType) throws SmartsheetException {
        String path = "shares/" + shareId;
        HashMap<String, String> queryParameters = new HashMap<String, String>();
        queryParameters.put(ASSET_ID_PARAM, assetId);
        queryParameters.put(ASSET_TYPE_PARAM, assetType);
        path = path + QueryUtil.generateUrl(null, queryParameters);
        return this.getResource(path, ShareResponse.class);
    }

    @Override
    public List<ShareResponse> shareTo(String assetId, String assetType, List<CreateShareRequest> shareRequests, Boolean sendEmail) throws SmartsheetException {
        Util.throwIfNull(shareRequests);
        Object path = SHARES_PATH;
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        queryParameters.put(ASSET_ID_PARAM, assetId);
        queryParameters.put(ASSET_TYPE_PARAM, assetType);
        if (sendEmail != null) {
            queryParameters.put("sendEmail", sendEmail);
        }
        path = (String)path + QueryUtil.generateUrl(null, queryParameters);
        return this.postAndReceiveList((String)path, shareRequests, ShareResponse.class);
    }

    @Override
    public ShareResponse updateShare(String shareId, String assetId, String assetType, UpdateShareRequest shareRequest) throws SmartsheetException {
        Util.throwIfNull(shareRequest);
        String path = "shares/" + shareId;
        HashMap<String, String> queryParameters = new HashMap<String, String>();
        queryParameters.put(ASSET_ID_PARAM, assetId);
        queryParameters.put(ASSET_TYPE_PARAM, assetType);
        path = path + QueryUtil.generateUrl(null, queryParameters);
        return this.patchResource(path, ShareResponse.class, shareRequest);
    }

    @Override
    public void deleteShare(String shareId, String assetId, String assetType) throws SmartsheetException {
        String path = "shares/" + shareId;
        HashMap<String, String> queryParameters = new HashMap<String, String>();
        queryParameters.put(ASSET_ID_PARAM, assetId);
        queryParameters.put(ASSET_TYPE_PARAM, assetType);
        path = path + QueryUtil.generateUrl(null, queryParameters);
        this.deleteResource(path, ShareResponse.class);
    }
}

