/*
 * Decompiled with CFR 0.152.
 */
package com.smartsheet.api;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.LoggerFactory;

public enum Trace {
    RequestHeaders,
    RequestBody,
    RequestBodySummary,
    ResponseHeaders,
    ResponseBody,
    ResponseBodySummary,
    Request{

        @Override
        public boolean addReplacements(Set<Trace> traces) {
            traces.add(RequestHeaders);
            traces.add(RequestBodySummary);
            return true;
        }
    }
    ,
    Response{

        @Override
        public boolean addReplacements(Set<Trace> traces) {
            traces.add(ResponseHeaders);
            traces.add(ResponseBodySummary);
            return true;
        }
    };


    public boolean addReplacements(Set<Trace> traces) {
        return false;
    }

    public static Set<Trace> parse(String traces) {
        if (traces == null || traces.trim().isEmpty()) {
            return Collections.emptySet();
        }
        String[] parts = traces.split("[, ]+");
        HashSet<Trace> results = new HashSet<Trace>(parts.length + parts.length / 2);
        for (String part : parts) {
            try {
                Trace trace = Trace.valueOf(part);
                if (trace.addReplacements(results)) continue;
                results.add(trace);
            }
            catch (IllegalArgumentException iax) {
                LoggerFactory.getLogger(Trace.class).warn("invalid trace in parse() - '{}'", (Object)part);
            }
        }
        return !results.isEmpty() ? results : Collections.emptySet();
    }
}

