/*
 * Copyright (C) 2025 Smartsheet
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Model classes representing Smartsheet API objects.
 * <p>
 * This package contains the data model classes that represent the various objects in the
 * Smartsheet API, including:
 * </p>
 * <ul>
 *   <li>Sheets, rows, columns, and cells</li>
 *   <li>Workspaces, folders, and reports</li>
 *   <li>Users, groups, and contacts</li>
 *   <li>Attachments, discussions, and comments</li>
 *   <li>Shares, webhooks, and automation rules</li>
 *   <li>And many other Smartsheet objects</li>
 * </ul>
 * <p>
 * These model classes are used for both request and response payloads when interacting with
 * the Smartsheet API. They provide a strongly-typed interface for working with Smartsheet data.
 * </p>
 *
 * @see com.smartsheet.api.models.Sheet
 * @see com.smartsheet.api.models.Row
 * @see com.smartsheet.api.models.Cell
 * @see com.smartsheet.api.models.Column
 */
package com.smartsheet.api.models;
