/*
 * Copyright (C) 2025 Smartsheet
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal OAuth implementation for the Smartsheet Java SDK.
 * <p>
 * This package contains the internal implementation classes for OAuth 2.0 authentication flows.
 * It provides the underlying functionality for the public OAuth API defined in
 * {@link com.smartsheet.api.oauth}.
 * </p>
 * <p>
 * <strong>Note:</strong> This is an internal package and its classes should not be directly
 * referenced by SDK users. Use the public OAuth interfaces in {@link com.smartsheet.api.oauth}
 * instead.
 * </p>
 *
 * @see com.smartsheet.api.oauth
 */
package com.smartsheet.api.internal.oauth;
