/*
 * Copyright (C) 2025 Smartsheet
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * JSON serialization and deserialization components for the Smartsheet Java SDK.
 * <p>
 * This package contains custom JSON serializers, deserializers, and related components built
 * on top of Jackson. These classes handle the conversion between Java objects and JSON payloads
 * used by the Smartsheet API, including special handling for polymorphic types and complex
 * object structures.
 * </p>
 * <p>
 * <strong>Note:</strong> This is an internal package and its classes should not be directly
 * referenced by SDK users.
 * </p>
 *
 * @see com.smartsheet.api.internal.json.JsonSerializer
 */
package com.smartsheet.api.internal.json;
