/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.api.sdk.file.response;

import com.smartling.api.sdk.exceptions.SmartlingApiException;
import com.smartling.api.sdk.file.response.Error;
import com.smartling.web.api.v2.ResponseCode;
import com.smartling.web.api.v2.ResponseData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class Response<T extends ResponseData> {
    private ResponseCode code;
    private List<Error> errors;
    private T data;

    public Response() {
    }

    public Response(ResponseCode code, List<Error> errors, T data) {
        this.code = code;
        this.errors = errors;
        this.data = data;
    }

    public ResponseCode getCode() {
        return this.code;
    }

    public void setCode(ResponseCode code) {
        this.code = code;
    }

    public List<Error> getErrors() {
        return this.errors;
    }

    public void setErrors(List<Error> errors) {
        this.errors = errors;
    }

    public T getData() {
        return this.data;
    }

    public T retrieveData() throws SmartlingApiException {
        if (this.code != null && this.code != ResponseCode.SUCCESS && this.code != ResponseCode.ACCEPTED) {
            List<Object> errors = this.errors != null ? this.errors : Collections.emptyList();
            ArrayList<String> messages = new ArrayList<String>(errors.size());
            for (Error error : errors) {
                messages.add(error.toString());
            }
            throw new SmartlingApiException(this.code.toString() + '\n' + StringUtils.join(messages, (char)'\n'), errors);
        }
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }
}

