/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.api.sdk;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.smartling.api.sdk.exceptions.SmartlingApiException;
import com.smartling.api.sdk.file.response.ApiV2ResponseWrapper;
import com.smartling.api.sdk.file.response.Response;
import com.smartling.api.sdk.util.DateTypeAdapter;
import com.smartling.api.sdk.util.HttpUtils;
import com.smartling.web.api.v2.ResponseData;
import java.io.IOException;
import java.util.Date;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;

public abstract class BaseApiClient {
    public static final String DEFAULT_API_GATEWAY_URL = "https://api.smartling.com";
    private static final String APPLICATION_JSON_TYPE = "application/json";
    protected HttpUtils httpUtils = new HttpUtils();

    public HttpUtils getHttpUtils() {
        return this.httpUtils;
    }

    public void setHttpUtils(HttpUtils httpUtils) {
        this.httpUtils = httpUtils;
    }

    protected static <T extends ResponseData> Response<T> getApiV2Response(String response, TypeToken<ApiV2ResponseWrapper<T>> responseType) throws SmartlingApiException {
        String fixedResponse = response.replaceAll("\"data\"\\:\"\"", "\"data\":null");
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(Date.class, (Object)new DateTypeAdapter());
        Gson gson = builder.create();
        ApiV2ResponseWrapper responseWrapper = (ApiV2ResponseWrapper)gson.fromJson(fixedResponse, responseType.getType());
        if (BaseApiClient.isValidResponse(responseWrapper)) {
            return responseWrapper.getResponse();
        }
        throw new SmartlingApiException(String.format("Response hasn't been parsed correctly [response='%s']", response));
    }

    private static <T extends ResponseData> boolean isValidResponse(ApiV2ResponseWrapper<T> responseWrapper) {
        return responseWrapper != null && responseWrapper.getResponse().getCode() != null;
    }

    protected HttpPost createJsonPostRequest(String url, Object command) throws SmartlingApiException {
        HttpPost httpPost = new HttpPost(url);
        try {
            Gson gson = new Gson();
            StringEntity stringEntity = new StringEntity(gson.toJson(command));
            stringEntity.setContentType(APPLICATION_JSON_TYPE);
            stringEntity.setContentEncoding("UTF-8");
            httpPost.setEntity((HttpEntity)stringEntity);
        }
        catch (IOException e) {
            throw new SmartlingApiException(e);
        }
        return httpPost;
    }
}

