/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.api.sdk.util;

import com.smartling.api.sdk.ProxyConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public class HttpProxyUtils {
    public RequestConfig getProxyRequestConfig(HttpRequestBase httpRequest, ProxyConfiguration proxyConfiguration) {
        if (HttpProxyUtils.hasActiveProxyConfiguration(proxyConfiguration)) {
            HttpHost proxyHttpHost = new HttpHost(proxyConfiguration.getHost(), proxyConfiguration.getPort());
            return RequestConfig.custom().setProxy(proxyHttpHost).build();
        }
        return null;
    }

    public CloseableHttpClient getHttpClient(ProxyConfiguration proxyConfiguration) {
        HttpClientBuilder httpClientBuilder = this.getHttpClientBuilder();
        if (HttpProxyUtils.proxyAuthenticationRequired(proxyConfiguration)) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(new AuthScope(proxyConfiguration.getHost(), proxyConfiguration.getPort()), (Credentials)new UsernamePasswordCredentials(proxyConfiguration.getUsername(), proxyConfiguration.getPassword()));
            httpClientBuilder = httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        }
        return httpClientBuilder.build();
    }

    HttpClientBuilder getHttpClientBuilder() {
        return HttpClientBuilder.create();
    }

    private static boolean hasActiveProxyConfiguration(ProxyConfiguration proxyConfiguration) {
        return proxyConfiguration != null && proxyConfiguration.getHost() != null && proxyConfiguration.getPort() != 0;
    }

    private static boolean proxyAuthenticationRequired(ProxyConfiguration proxyConfiguration) {
        return HttpProxyUtils.hasActiveProxyConfiguration(proxyConfiguration) && StringUtils.isNotEmpty((CharSequence)proxyConfiguration.getUsername()) && StringUtils.isNotEmpty((CharSequence)proxyConfiguration.getPassword());
    }
}

