/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.api.sdk.auth;

import com.smartling.web.api.v2.ResponseData;
import org.apache.http.HttpMessage;

public class AuthenticationContext
implements ResponseData {
    public static final int TIME_TO_RESFRESH = 1500;
    private String accessToken;
    private long parsingTime = System.currentTimeMillis();
    private long expiresIn;
    private long refreshExpiresIn;
    private String refreshToken;
    private String tokenType;
    private String sessionState;

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public long getExpiresIn() {
        return this.expiresIn;
    }

    public void setExpiresIn(long expiresIn) {
        this.expiresIn = expiresIn;
    }

    public long getRefreshExpiresIn() {
        return this.refreshExpiresIn;
    }

    public void setRefreshExpiresIn(long refreshExpiresIn) {
        this.refreshExpiresIn = refreshExpiresIn;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public String getSessionState() {
        return this.sessionState;
    }

    public void setSessionState(String sessionState) {
        this.sessionState = sessionState;
    }

    public String getAuthorizationTokenString() {
        return String.format("%s %s", this.getTokenType(), this.getAccessToken());
    }

    public void applyTo(HttpMessage httpMessage) {
        httpMessage.addHeader("Authorization", this.getAuthorizationTokenString());
    }

    public long getParsingTime() {
        return this.parsingTime;
    }

    public void setParsingTime(long parsingTime) {
        this.parsingTime = parsingTime;
    }

    public long calculateAccessTokenExpireTime() {
        return this.parsingTime + this.expiresIn * 1000L - 1500L;
    }

    public long getRefreshTokenExpireTime() {
        return this.parsingTime + this.refreshExpiresIn * 1000L - 1500L;
    }
}

