/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.api.sdk.util;

import com.smartling.api.sdk.HttpClientConfiguration;
import com.smartling.api.sdk.LibNameVersionHolder;
import com.smartling.api.sdk.ProxyConfiguration;
import com.smartling.api.sdk.dto.file.StringResponse;
import com.smartling.api.sdk.exceptions.SmartlingApiException;
import com.smartling.api.sdk.util.HttpClientFactory;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpMessage;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;

public class HttpUtils {
    private static final Log LOGGER = LogFactory.getLog(HttpUtils.class);
    private static final String LOG_MESSAGE_ERROR_TEMPLATE = "GENERAL ERROR: %s";
    private static final String X_SL_REQUEST_ID = "X-SL-RequestId";
    static final String SCHEME_HTTPS = "https";
    static final String SCHEME_HTTP = "http";
    static final String PROPERTY_SUFFIX_PROXY_HOST = ".proxyHost";
    static final String PROPERTY_SUFFIX_PROXY_PORT = ".proxyPort";
    static final String PROPERTY_SUFFIX_PROXY_USERNAME = ".proxyUsername";
    static final String PROPERTY_SUFFIX_PROXY_PASSWORD = ".proxyPassword";
    private static final ThreadLocal<String> requestId = new ThreadLocal();
    private static final ThreadLocal<ResponseDetails> responseDetails = new ThreadLocal();
    private HttpClientFactory httpClientFactory = new HttpClientFactory();

    void setHttpClientFactory(HttpClientFactory httpClientFactory) {
        this.httpClientFactory = httpClientFactory;
    }

    public static ThreadLocal<String> getRequestId() {
        return requestId;
    }

    public static ThreadLocal<ResponseDetails> getResponseDetails() {
        return responseDetails;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public StringResponse executeHttpCall(HttpRequestBase httpRequest, ProxyConfiguration proxyConfiguration, HttpClientConfiguration httpClientConfiguration) throws SmartlingApiException {
        StringResponse stringResponse;
        CloseableHttpClient httpClient = null;
        try {
            requestId.remove();
            responseDetails.remove();
            ProxyConfiguration newProxyConfiguration = this.mergeSystemProxyConfiguration(proxyConfiguration);
            this.logProxyConfiguration(newProxyConfiguration);
            httpClient = this.httpClientFactory.getHttpClient(newProxyConfiguration, httpClientConfiguration);
            this.addUserAgentHeader((HttpMessage)httpRequest);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpRequest);
            String charset = EntityUtils.getContentCharSet((HttpEntity)response.getEntity());
            int statusCode = response.getStatusLine().getStatusCode();
            Header header = response.getFirstHeader(X_SL_REQUEST_ID);
            if (header != null) {
                requestId.set(header.getValue());
            }
            ResponseDetails details = new ResponseDetails(statusCode, response.getAllHeaders());
            responseDetails.set(details);
            stringResponse = this.inputStreamToString(response.getEntity().getContent(), charset, statusCode);
        }
        catch (IOException ioe) {
            try {
                LOGGER.error((Object)String.format(LOG_MESSAGE_ERROR_TEMPLATE, ioe.getMessage()));
                throw new SmartlingApiException(ioe);
            }
            catch (Throwable throwable) {
                try {
                    if (null == httpClient) throw throwable;
                    httpClient.close();
                    throw throwable;
                }
                catch (IOException ioe2) {
                    LOGGER.warn((Object)String.format(LOG_MESSAGE_ERROR_TEMPLATE, ioe2.getMessage()));
                }
                throw throwable;
            }
        }
        try {
            if (null == httpClient) return stringResponse;
            httpClient.close();
            return stringResponse;
        }
        catch (IOException ioe) {
            LOGGER.warn((Object)String.format(LOG_MESSAGE_ERROR_TEMPLATE, ioe.getMessage()));
        }
        return stringResponse;
    }

    private void logProxyConfiguration(ProxyConfiguration proxyConfiguration) {
        if (proxyConfiguration != null) {
            LOGGER.trace((Object)String.format("Using proxy configuration for executing http call: '%s'", proxyConfiguration));
        } else {
            LOGGER.trace((Object)"Proxy is not set");
        }
    }

    private StringResponse inputStreamToString(InputStream inputStream, String encoding, int httpCode) throws IOException {
        byte[] contentsRaw = IOUtils.toByteArray((InputStream)inputStream);
        String responseEncoding = null == encoding || !encoding.toUpperCase().contains("UTF-16") ? "UTF-8" : "UTF-16";
        String contents = new String(contentsRaw, responseEncoding);
        return new StringResponse(contents, contentsRaw, responseEncoding, httpCode == 200);
    }

    private ProxyConfiguration mergeSystemProxyConfiguration(ProxyConfiguration proxyConfiguration) {
        String protocol = this.defineSchemeFromSystemProperties();
        if (protocol != null) {
            ProxyConfiguration newProxyConfiguration = new ProxyConfiguration();
            newProxyConfiguration.setHost(System.getProperty(protocol + PROPERTY_SUFFIX_PROXY_HOST));
            newProxyConfiguration.setPort(Integer.valueOf(System.getProperty(protocol + PROPERTY_SUFFIX_PROXY_PORT)));
            newProxyConfiguration.setUsername(System.getProperty(protocol + PROPERTY_SUFFIX_PROXY_USERNAME));
            newProxyConfiguration.setPassword(System.getProperty(protocol + PROPERTY_SUFFIX_PROXY_PASSWORD));
            return newProxyConfiguration;
        }
        return proxyConfiguration;
    }

    private String defineSchemeFromSystemProperties() {
        if (StringUtils.isNotBlank((CharSequence)System.getProperty("https.proxyHost")) && StringUtils.isNotBlank((CharSequence)System.getProperty("https.proxyPort"))) {
            return SCHEME_HTTPS;
        }
        if (StringUtils.isNotBlank((CharSequence)System.getProperty("http.proxyHost")) && StringUtils.isNotBlank((CharSequence)System.getProperty("http.proxyPort"))) {
            return SCHEME_HTTP;
        }
        return null;
    }

    private void addUserAgentHeader(HttpMessage httpMessage) throws SmartlingApiException {
        String userAgentHeaderValue = LibNameVersionHolder.getClientLibName() + "/" + LibNameVersionHolder.getClientLibVersion();
        httpMessage.addHeader("User-Agent", userAgentHeaderValue);
    }

    public static class ResponseDetails {
        private int statusCode;
        private Header[] headers;

        private ResponseDetails(int statusCode, Header[] headers) {
            this.statusCode = statusCode;
            this.headers = headers;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public Header[] getHeaders() {
            return this.headers != null ? this.headers : new Header[]{};
        }
    }
}

