/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.api.sdk.util;

import com.smartling.api.sdk.HttpClientConfiguration;
import com.smartling.api.sdk.ProxyConfiguration;
import com.smartling.api.sdk.exceptions.SmartlingApiException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

class HttpClientFactory {
    HttpClientFactory() {
    }

    CloseableHttpClient getHttpClient(ProxyConfiguration proxyConfiguration, HttpClientConfiguration httpClientConfiguration) throws SmartlingApiException {
        HttpClientBuilder httpClientBuilder = this.getHttpClientBuilder();
        if (HttpClientFactory.hasActiveProxyConfiguration(proxyConfiguration)) {
            HttpHost proxyHost = new HttpHost(proxyConfiguration.getHost(), proxyConfiguration.getPort());
            httpClientBuilder.setProxy(proxyHost);
            if (HttpClientFactory.proxyAuthenticationRequired(proxyConfiguration)) {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(new AuthScope(proxyConfiguration.getHost(), proxyConfiguration.getPort()), (Credentials)new UsernamePasswordCredentials(proxyConfiguration.getUsername(), proxyConfiguration.getPassword()));
                httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            }
        }
        httpClientBuilder.setSSLContext(this.getSSLConfig());
        if (this.httpConfigurationRequired(httpClientConfiguration)) {
            RequestConfig defaultRequestConfig = RequestConfig.custom().setSocketTimeout(httpClientConfiguration.getSocketTimeout()).setConnectTimeout(httpClientConfiguration.getConnectionTimeout()).setConnectionRequestTimeout(httpClientConfiguration.getConnectionRequestTimeout()).build();
            httpClientBuilder.setDefaultRequestConfig(defaultRequestConfig);
        }
        return httpClientBuilder.build();
    }

    private SSLContext getSSLConfig() throws SmartlingApiException {
        SSLContext sslContext = null;
        try {
            sslContext = SSLContext.getInstance("TLSv1.2");
            this.initSSLContext(sslContext);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SmartlingApiException("Error while creating HTTPClient, can not initialize TLS version", e);
        }
        return sslContext;
    }

    private void initSSLContext(SSLContext sslContext) throws SmartlingApiException {
        try {
            sslContext.init(null, null, null);
        }
        catch (KeyManagementException e) {
            throw new SmartlingApiException("Error while creating HTTPClient", e);
        }
    }

    private boolean httpConfigurationRequired(HttpClientConfiguration httpClientConfiguration) {
        return httpClientConfiguration != null;
    }

    HttpClientBuilder getHttpClientBuilder() {
        return HttpClientBuilder.create();
    }

    private static boolean hasActiveProxyConfiguration(ProxyConfiguration proxyConfiguration) {
        return proxyConfiguration != null && proxyConfiguration.getHost() != null && proxyConfiguration.getPort() != 0;
    }

    private static boolean proxyAuthenticationRequired(ProxyConfiguration proxyConfiguration) {
        return HttpClientFactory.hasActiveProxyConfiguration(proxyConfiguration) && StringUtils.isNotEmpty((CharSequence)proxyConfiguration.getUsername()) && StringUtils.isNotEmpty((CharSequence)proxyConfiguration.getPassword());
    }
}

