/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.api.sdk;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.smartling.api.sdk.ProxyConfiguration;
import com.smartling.api.sdk.dto.file.StringResponse;
import com.smartling.api.sdk.exceptions.SmartlingApiException;
import com.smartling.api.sdk.file.response.ApiV2ResponseWrapper;
import com.smartling.api.sdk.file.response.Response;
import com.smartling.api.sdk.util.DateTypeAdapter;
import com.smartling.api.sdk.util.HttpUtils;
import com.smartling.web.api.v2.ResponseData;
import java.util.Date;
import java.util.Objects;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;

public abstract class BaseApiClient {
    public static final String DEFAULT_BASE_URL = "https://api.smartling.com";
    private final HttpUtils httpUtils = new HttpUtils();
    private final ProxyConfiguration proxyConfiguration;
    protected final String baseUrl;

    protected BaseApiClient() {
        this(DEFAULT_BASE_URL, null);
    }

    protected BaseApiClient(String baseUrl, ProxyConfiguration proxyConfiguration) {
        this.baseUrl = Objects.requireNonNull(baseUrl, "Base URL can not be null");
        this.proxyConfiguration = proxyConfiguration;
    }

    protected StringResponse executeRequest(HttpRequestBase request) throws SmartlingApiException {
        return this.httpUtils.executeHttpCall(request, this.proxyConfiguration);
    }

    protected static <T extends ResponseData> Response<T> getApiV2Response(String response, TypeToken<ApiV2ResponseWrapper<T>> responseType) throws SmartlingApiException {
        String fixedResponse = response.replaceAll("\"data\":\"\"", "\"data\":null");
        try {
            GsonBuilder builder = new GsonBuilder();
            builder.registerTypeAdapter(Date.class, (Object)new DateTypeAdapter());
            Gson gson = builder.create();
            ApiV2ResponseWrapper responseWrapper = (ApiV2ResponseWrapper)gson.fromJson(fixedResponse, responseType.getType());
            if (!BaseApiClient.isValidResponse(responseWrapper)) {
                throw new SmartlingApiException(String.format("Response hasn't been parsed correctly [response='%s']", response));
            }
            return responseWrapper.getResponse();
        }
        catch (JsonParseException e) {
            throw new SmartlingApiException(String.format("Can't parse response as JSON [response='%s']", response), e);
        }
    }

    private static <T extends ResponseData> boolean isValidResponse(ApiV2ResponseWrapper<T> responseWrapper) {
        return responseWrapper != null && responseWrapper.getResponse().getCode() != null;
    }

    protected static HttpPost createJsonPostRequest(String url, Object command) throws SmartlingApiException {
        String json = new Gson().toJson(command);
        HttpPost httpPost = new HttpPost(url);
        StringEntity stringEntity = new StringEntity(json, ContentType.APPLICATION_JSON);
        stringEntity.setContentEncoding("UTF-8");
        httpPost.setEntity((HttpEntity)stringEntity);
        return httpPost;
    }
}

