/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.api.sdk.util;

import com.smartling.api.sdk.ProxyConfiguration;
import com.smartling.api.sdk.dto.file.StringResponse;
import com.smartling.api.sdk.exceptions.SmartlingApiException;
import com.smartling.api.sdk.util.HttpProxyUtils;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;

public class HttpUtils {
    private static final Log logger = LogFactory.getLog(HttpUtils.class);
    private static final String LOG_MESSAGE_ERROR_TEMPLATE = "GENERAL ERROR: %s";
    static final String SCHEME_HTTPS = "https";
    static final String SCHEME_HTTP = "http";
    static final String PROPERTY_SUFFIX_PROXY_HOST = ".proxyHost";
    static final String PROPERTY_SUFFIX_PROXY_PORT = ".proxyPort";
    static final String PROPERTY_SUFFIX_PROXY_USERNAME = ".proxyUsername";
    static final String PROPERTY_SUFFIX_PROXY_PASSWORD = ".proxyPassword";
    private HttpProxyUtils httpProxyUtils = new HttpProxyUtils();

    public void setHttpProxyUtils(HttpProxyUtils httpProxyUtils) {
        this.httpProxyUtils = httpProxyUtils;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public StringResponse executeHttpCall(HttpRequestBase httpRequest, ProxyConfiguration proxyConfiguration) throws SmartlingApiException {
        StringResponse stringResponse;
        CloseableHttpClient httpClient = null;
        try {
            ProxyConfiguration newProxyConfiguration = this.mergeSystemProxyConfiguration(proxyConfiguration);
            httpClient = this.httpProxyUtils.getHttpClient(newProxyConfiguration);
            RequestConfig proxyRequestConfig = this.httpProxyUtils.getProxyRequestConfig(httpRequest, newProxyConfiguration);
            if (proxyRequestConfig != null) {
                httpRequest.setConfig(proxyRequestConfig);
            }
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpRequest);
            String charset = EntityUtils.getContentCharSet((HttpEntity)response.getEntity());
            int statusCode = response.getStatusLine().getStatusCode();
            stringResponse = this.inputStreamToString(response.getEntity().getContent(), charset, statusCode);
        }
        catch (IOException ioe) {
            try {
                logger.error((Object)String.format(LOG_MESSAGE_ERROR_TEMPLATE, ioe.getMessage()));
                throw new SmartlingApiException(ioe);
            }
            catch (Throwable throwable) {
                try {
                    if (null == httpClient) throw throwable;
                    httpClient.close();
                    throw throwable;
                }
                catch (IOException ioe2) {
                    logger.warn((Object)String.format(LOG_MESSAGE_ERROR_TEMPLATE, ioe2.getMessage()));
                }
                throw throwable;
            }
        }
        try {
            if (null == httpClient) return stringResponse;
            httpClient.close();
            return stringResponse;
        }
        catch (IOException ioe) {
            logger.warn((Object)String.format(LOG_MESSAGE_ERROR_TEMPLATE, ioe.getMessage()));
        }
        return stringResponse;
    }

    private StringResponse inputStreamToString(InputStream inputStream, String encoding, int httpCode) throws IOException {
        byte[] contentsRaw = IOUtils.toByteArray((InputStream)inputStream);
        String responseEncoding = null == encoding || !encoding.toUpperCase().contains("UTF-16") ? "UTF-8" : "UTF-16";
        String contents = new String(contentsRaw, responseEncoding);
        return new StringResponse(contents, contentsRaw, responseEncoding, httpCode == 200);
    }

    private ProxyConfiguration mergeSystemProxyConfiguration(ProxyConfiguration proxyConfiguration) {
        String protocol = this.defineSchemeFromSystemProperties();
        if (protocol != null) {
            ProxyConfiguration newProxyConfiguration = new ProxyConfiguration();
            newProxyConfiguration.setHost(System.getProperty(protocol + PROPERTY_SUFFIX_PROXY_HOST));
            newProxyConfiguration.setPort(Integer.valueOf(System.getProperty(protocol + PROPERTY_SUFFIX_PROXY_PORT)));
            newProxyConfiguration.setUsername(System.getProperty(protocol + PROPERTY_SUFFIX_PROXY_USERNAME));
            newProxyConfiguration.setPassword(System.getProperty(protocol + PROPERTY_SUFFIX_PROXY_PASSWORD));
            return newProxyConfiguration;
        }
        return proxyConfiguration;
    }

    private String defineSchemeFromSystemProperties() {
        if (StringUtils.isNotBlank((CharSequence)System.getProperty("https.proxyHost")) && StringUtils.isNotBlank((CharSequence)System.getProperty("https.proxyPort"))) {
            return SCHEME_HTTPS;
        }
        if (StringUtils.isNotBlank((CharSequence)System.getProperty("http.proxyHost")) && StringUtils.isNotBlank((CharSequence)System.getProperty("http.proxyPort"))) {
            return SCHEME_HTTP;
        }
        return null;
    }
}

