/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.api.sdk.util;

import com.smartling.api.sdk.ProxyConfiguration;
import com.smartling.api.sdk.dto.file.StringResponse;
import com.smartling.api.sdk.exceptions.ApiException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;

public class HttpUtils {
    private static final Log logger = LogFactory.getLog(HttpUtils.class);
    private static final String LOG_MESSAGE_ERROR_TEMPLATE = "GENERAL ERROR: %s";

    private HttpUtils() {
    }

    public static StringResponse executeHttpCall(HttpRequestBase httpRequest, ProxyConfiguration proxyConfiguration) throws ApiException {
        DefaultHttpClient httpClient = null;
        try {
            httpClient = new DefaultHttpClient();
            ProxyUtils.setupProxy((HttpClient)httpClient, proxyConfiguration);
            HttpResponse response = httpClient.execute((HttpUriRequest)httpRequest);
            if (response.getStatusLine().getStatusCode() == 200) {
                StringResponse stringResponse = HttpUtils.inputStreamToString(response.getEntity().getContent(), null);
                return stringResponse;
            }
            try {
                throw new ApiException(HttpUtils.inputStreamToString(response.getEntity().getContent(), null).getContents());
            }
            catch (IOException ioe) {
                logger.error((Object)String.format(LOG_MESSAGE_ERROR_TEMPLATE, ioe.getMessage()));
                throw new ApiException(ioe);
            }
        }
        finally {
            if (null != httpClient) {
                httpClient.getConnectionManager().shutdown();
            }
        }
    }

    private static StringResponse inputStreamToString(InputStream inputStream, String encoding) throws IOException {
        StringWriter writer = new StringWriter();
        String responseEncoding = null == encoding || !encoding.toUpperCase().contains("UTF-16") ? "UTF-8" : "UTF-16";
        IOUtils.copy((InputStream)inputStream, (Writer)writer, (String)responseEncoding);
        return new StringResponse(writer.toString(), responseEncoding);
    }

    private static class ProxyUtils {
        private static final String SCHEME_HTTPS = "https";
        private static final String SCHEME_HTTP = "http";
        private static final String PROPERTY_SUFFIX_PROXY_HOST = ".proxyHost";
        private static final String PROPERTY_SUFFIX_PROXY_PORT = ".proxyPort";
        private static final String PROPERTY_SUFFIX_PROXY_USERNAME = ".proxyUsername";
        private static final String PROPERTY_SUFFIX_PROXY_PASSWORD = ".proxyPassword";

        private ProxyUtils() {
        }

        public static void setupProxy(HttpClient httpClient, ProxyConfiguration configuration) {
            if (null != configuration) {
                ProxyUtils.setProxyToHttpClient(httpClient, configuration.getHost(), configuration.getPort(), configuration.getUsername(), configuration.getPassword());
            } else {
                ProxyUtils.setupProxyFromSystemProperties(httpClient);
            }
        }

        public static void setupProxyFromSystemProperties(HttpClient httpClient) {
            String protocol = ProxyUtils.defineSchemeFromSystemProperties();
            if (null != protocol) {
                ProxyUtils.setProxyToHttpClient(httpClient, System.getProperty(protocol + PROPERTY_SUFFIX_PROXY_HOST), Integer.valueOf(System.getProperty(protocol + PROPERTY_SUFFIX_PROXY_PORT)), System.getProperty(protocol + PROPERTY_SUFFIX_PROXY_USERNAME), System.getProperty(protocol + PROPERTY_SUFFIX_PROXY_PASSWORD));
            }
        }

        private static void setProxyToHttpClient(HttpClient httpClient, String proxyHost, Integer proxyPort, String username, String password) {
            if (null == proxyHost || null == proxyPort) {
                return;
            }
            if (StringUtils.isNotBlank((String)username) && StringUtils.isNotBlank((String)password) && httpClient instanceof DefaultHttpClient) {
                ((DefaultHttpClient)httpClient).getCredentialsProvider().setCredentials(new AuthScope(proxyHost, proxyPort.intValue()), (Credentials)new UsernamePasswordCredentials(username, password));
            }
            HttpHost proxy = new HttpHost(proxyHost, proxyPort.intValue());
            httpClient.getParams().setParameter("http.route.default-proxy", (Object)proxy);
        }

        private static String defineSchemeFromSystemProperties() {
            if (StringUtils.isNotBlank((String)System.getProperty("https.proxyHost")) && StringUtils.isNotBlank((String)System.getProperty("https.proxyPort"))) {
                return SCHEME_HTTPS;
            }
            if (StringUtils.isNotBlank((String)System.getProperty("http.proxyHost")) && StringUtils.isNotBlank((String)System.getProperty("http.proxyPort"))) {
                return SCHEME_HTTP;
            }
            return null;
        }
    }
}

