/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.api.sdk.file.util;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.smartling.api.sdk.file.util.DateFormatter;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateTypeAdapter
extends TypeAdapter<Date> {
    public Date read(JsonReader reader) throws IOException {
        if (reader.peek() == JsonToken.NULL) {
            reader.nextNull();
            return null;
        }
        String value = reader.nextString();
        try {
            return DateFormatter.parse(value);
        }
        catch (ParseException e) {
            throw new IOException(e);
        }
    }

    public void write(JsonWriter writer, Date value) throws IOException {
        if (value == null) {
            writer.nullValue();
            return;
        }
        String xy = DateFormatter.format(value);
        writer.value(xy);
    }
}

