/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.api.sdk.file.commandline;

import com.smartling.api.sdk.file.FileApiClientAdapterImpl;
import com.smartling.api.sdk.file.FileApiException;
import com.smartling.api.sdk.file.FileType;
import com.smartling.api.sdk.file.commandline.UploadFileParams;
import com.smartling.api.sdk.file.parameters.FileUploadParameterBuilder;
import com.smartling.api.sdk.file.response.ApiResponse;
import com.smartling.api.sdk.file.response.UploadData;
import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UploadFile {
    private static final Log logger = LogFactory.getLog((String)"com.smartling.api.sdk.file.commandline.UploadFile");
    private static final String RESULT = "Result for %s: %s";

    public static void main(String[] args) throws FileApiException {
        UploadFile.upload(args);
    }

    protected static ApiResponse<UploadData> upload(String[] args) throws FileApiException {
        UploadFileParams uploadParams = UploadFile.getParameters(args);
        File file = new File(uploadParams.getPathToFile());
        FileApiClientAdapterImpl smartlingFAPI = new FileApiClientAdapterImpl(uploadParams.isProductionMode(), uploadParams.getApiKey(), uploadParams.getProjectId());
        FileUploadParameterBuilder fileUploadParameterBuilder = new FileUploadParameterBuilder();
        fileUploadParameterBuilder.fileType(FileType.lookup(uploadParams.getFileType())).fileUri(file.getName()).approveContent(uploadParams.getApproveContent()).callbackUrl(uploadParams.getCallbackUrl());
        ApiResponse<UploadData> uploadResponse = smartlingFAPI.uploadFile(file, "UTF-8", fileUploadParameterBuilder);
        logger.info((Object)String.format(RESULT, file.getName(), uploadResponse));
        return uploadResponse;
    }

    private static UploadFileParams getParameters(String[] args) {
        Assert.isTrue((args.length >= 6 ? 1 : 0) != 0, (String)"Invalid number of arguments");
        UploadFileParams uploadParams = new UploadFileParams();
        uploadParams.setProductionMode(Boolean.valueOf(args[0]));
        uploadParams.setApiKey(args[1]);
        uploadParams.setProjectId(args[2]);
        uploadParams.setPathToFile(args[3]);
        uploadParams.setFileType(args[4]);
        uploadParams.setApproveContent(null == args[5] ? null : Boolean.valueOf(args[5]));
        if (args.length == 7) {
            uploadParams.setCallbackUrl(args[6]);
        }
        return uploadParams;
    }
}

